/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 *
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer: JOnAS team
 * --------------------------------------------------------------------------
 * $Id: JonasApplicationRuleSet.java 22189 2012-03-05 10:45:00Z boukadam $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.deployment.ear.rules;

import org.ow2.jonas.deployment.common.rules.JRuleSetBase;

import org.apache.commons.digester.Digester;


/**
 * This class defines the rules to analyze the element jonas-application
 * @author Florent Benoit
 */

public class JonasApplicationRuleSet extends JRuleSetBase {

    /**
     * Construct an object with the prefix "jonas-application"
     */
    public JonasApplicationRuleSet() {
        super("jonas-application/");
    }

    /**
     * Add a set of rules to the digester object
     * @param digester Digester instance
     */
    public void addRuleInstances(Digester digester) {
        digester.addRuleSet(new JonasSecurityRuleSet(prefix));

        digester.addCallMethod(prefix + "tenant-id",
                "setTenantId", 0);
    }

}