/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASPromptProvider.java 22264 2012-03-21 15:27:18Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.shell.internal;

import org.apache.felix.service.command.CommandSession;
import org.ow2.shelbie.core.IPromptProvider;

/**
 * @author Loris Bouzonnet
 */
public class JOnASPromptProvider implements IPromptProvider {
    
    private String prompt;

    public void start() {
        prompt = System.getProperty("user.name") + "@" + System.getProperty("jonas.name", "jonas") + "$ ";
    }

    public String getPrompt(CommandSession commandSession) {
        return prompt;
    }

}
