/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DefaultBeanDeploymentArchiveTestCase.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld.internal.deployment;

import java.util.Collection;

import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.ow2.jonas.cdi.weld.internal.resource.ApplicationResourceLoader;
import org.ow2.util.archive.impl.MemoryArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

/**
 * Created by IntelliJ IDEA.
 * User: sauthieg
 * Date: 15 févr. 2010
 * Time: 13:54:52
 * To change this template use File | Settings | File Templates.
 */
public class DefaultBeanDeploymentArchiveTestCase {

    private DefaultBeanDeploymentArchive bda;
    private MemoryArchive archive;

    private static final String RESOURCE_NAME = UserTestBean.class.getName().replace('.', '/').concat(".class");

    @BeforeTest
    private void setUp() {
        ServiceRegistry registry = new SimpleServiceRegistry();
        registry.add(ResourceLoader.class, new ApplicationResourceLoader(getClass().getClassLoader()));
        archive = new MemoryArchive();
        // Create the BDA
        bda = new DefaultBeanDeploymentArchive("test-archive", archive, registry);
    }
    
    @Test
    public void testClassLoading() {
        // Add a classic Class resource
        archive.addResource(RESOURCE_NAME, null);

        Collection<Class<?>> classes = bda.getBeanClasses();
        Assert.assertEquals(classes.size(), 1, "Check that 1 class has been correctly loaded.");
        Assert.assertEquals(classes.iterator().next().getName(),
                            UserTestBean.class.getName(),
                            "Check that this is the good class.");
    }

    @Test
    public void testWebinfClassLoading() {
        // Add a resource located in WEB-INF/classes
        archive.addResource("WEB-INF/classes/" + RESOURCE_NAME, null);

        Collection<Class<?>> classes = bda.getBeanClasses();
        Assert.assertEquals(classes.size(), 1, "Check that 1 class has been correctly loaded.");
        Assert.assertEquals(classes.iterator().next().getName(),
                            UserTestBean.class.getName(),
                            "Check that this is the good class.");
    }
}
