/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DefaultDeploymentBuilderTestCase.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld.internal.deployment;

import java.io.File;
import java.util.Collection;

import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.ow2.jonas.cdi.weld.internal.mock.MockWeldService;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.archive.impl.MemoryArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by IntelliJ IDEA.
 * User: sauthieg
 * Date: 15 févr. 2010
 * Time: 13:54:52
 * To change this template use File | Settings | File Templates.
 */
public class DefaultDeploymentBuilderTestCase {

    private DefaultDeploymentBuilder builder;
    private MemoryArchive archive;

    @BeforeMethod
    private void setUp() throws Exception {

        builder = new DefaultDeploymentBuilder();
        builder.setArchiveManager(ArchiveManager.getInstance());
        builder.setWeldService(new MockWeldService());

        archive = new MemoryArchive();
        archive.addResource("WEB-INF/bean.xml", null);
    }

    @Test
    public void testSimpleWebApp() {

        Deployment deployment = builder.buildWebDeployment(archive);

        Collection<BeanDeploymentArchive> archives = deployment.getBeanDeploymentArchives();

        Assert.assertEquals(archives.size(), 1, "Only 1 BDA has to be returned.");
    }

    @Test
    public void testWebAppWithLibrary() throws Exception {
        // Provides a Webapp with 1 library

        String basedir = System.getProperty("basedir");
        File library = new File(basedir, "src/test/resources/library.jar".replace('/', File.separatorChar));

        archive.addResource("WEB-INF/lib/library.jar", library.toURI().toURL());
        
        Deployment deployment = builder.buildWebDeployment(archive);

        Collection<BeanDeploymentArchive> archives = deployment.getBeanDeploymentArchives();

        Assert.assertEquals(archives.size(), 2, "2 BDAs expected (WEB-INF/classes + WEB-INF/lib/library.jar).");

    }
}