/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbstractConfigurationAdapterTestCase.java 22065 2012-01-31 13:14:39Z joaninh $
 * --------------------------------------------------------------------------
 */


package org.ow2.jonas.configadmin.internal.generic;

import java.net.URL;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * A {@code AbstractConfigurationAdapterTestCase} is ...
 *
 * @author Guillaume Sauthier
 */
public class AbstractConfigurationAdapterTestCase {
    protected Element findFirstElementNamed(Document doc, String name) {
        Element root = doc.getDocumentElement();
        return (Element) root.getElementsByTagName(name).item(0);
    }

    protected URL getUrl(String name) {
        return getClass().getResource(name);
    }
}
