/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigurationAdapterRegistryTestCase.java 22065 2012-01-31 13:14:39Z joaninh $
 * --------------------------------------------------------------------------
 */


package org.ow2.jonas.configadmin.internal.generic;

import org.testng.annotations.Test;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * A {@code DefaultConfigurationAdapterRegistryTestCase} is ...
 *
 * @author Guillaume Sauthier
 */
public class ConfigurationAdapterRegistryTestCase {
    @Test
    public void testRegistrySupportsDefaultElements() throws Exception {
        DefaultConfigurationAdapterRegistry registry = new DefaultConfigurationAdapterRegistry();

        assertThat(registry.getAdapter("configuration"), is( notNullValue() ));
        assertThat(registry.getAdapter("factory-configuration"), is( notNullValue() ));
    }
}
