/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.Version;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployer;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployerLog;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonDeployableImpl;
import org.ow2.jonas.addon.deploy.impl.deployer.AddonMetaData;
import org.ow2.jonas.addon.deploy.impl.deployer.ConfDeployerImpl;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.lib.work.LogEntryImpl;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.properties.ServiceProperties;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.LogEntry;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonDeployerImpl
extends AbsDeployer<IAddonDeployable>
implements IAddonDeployer {
    private static Log logger = LogFactory.getLog(AddonDeployerImpl.class);
    private ServerProperties serverProperties;
    private IDeployableHelper deployableHelper;
    private Map<URL, IAddonDeployable> addons = null;
    private IAddonDeployerLog<IAddonLogEntry> deployerLog;
    private IDeployerLog workCleanerLog;
    private IDeployerManager deployerManager;
    private List<String> deployedAddonNames;
    private BundleContext bundleContext;
    private ConfDeployerImpl confDeployer;
    private ServiceManager serviceManager;
    private boolean isInitialized;
    private List<ServiceRegistration> serviceRegistrations;
    public final String SERVICE_REGISTRATION_SERVICE_PROPERTY = "service";
    public static final String XSD_RESOURCE = "/META-INF/jonas-addon-1.0.xsd";

    public AddonDeployerImpl(ServerProperties serverProperties, IDeployableHelper deployableHelper, IAddonDeployerLog<IAddonLogEntry> deployerLog, IDeployerManager deployerManager, BundleContext bundleContext, ServiceManager serviceManager, IDeployerLog<LogEntry> workCleanerLog) {
        this.serverProperties = serverProperties;
        this.deployableHelper = deployableHelper;
        this.deployerLog = deployerLog;
        this.workCleanerLog = workCleanerLog;
        this.deployerManager = deployerManager;
        this.addons = new HashMap<URL, IAddonDeployable>();
        this.deployedAddonNames = new ArrayList<String>();
        this.bundleContext = bundleContext;
        this.serviceManager = serviceManager;
        this.confDeployer = new ConfDeployerImpl(this.bundleContext);
        this.isInitialized = false;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
        try {
            this.checkLogs();
        }
        catch (DeployerException e) {
            logger.error((Object)"Checked log has failed", new Object[]{e});
        }
    }

    private void checkLogs() throws DeployerException {
        HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
        Vector logEntries = this.deployerLog.getEntries();
        Vector<IAddonLogEntry> logEntriesToRemove = new Vector<IAddonLogEntry>();
        for (IAddonLogEntry logEntry : logEntries) {
            File orginalFile = logEntry.getOriginal();
            File unpackedFile = logEntry.getCopy();
            if (orginalFile != null && orginalFile.exists()) continue;
            addonsToUndeploy.put(logEntry.getName(), unpackedFile.getAbsolutePath());
            logEntriesToRemove.add(logEntry);
        }
        this.retrieveJOnASConfiguration(addonsToUndeploy);
        for (IAddonLogEntry logEntry : logEntriesToRemove) {
            try {
                this.deployerLog.removeEntry((LogEntry)logEntry);
                logger.info((Object)"''{0}'' Addon Deployable is now undeployed", new Object[]{logEntry.getOriginal().getAbsolutePath()});
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Cannot remove log entry " + logEntry.getName() + "."), new Object[]{e});
            }
        }
    }

    public void doDeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        URL originalURL;
        AddonMetaData addonMetaData;
        File unpackedFile;
        IArchive archive;
        String unpackedFileName;
        File originalFile = null;
        try {
            originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the deployable " + deployable.getShortName(), (Throwable)e);
        }
        IAddonLogEntry logEntry = (IAddonLogEntry)this.deployerLog.getEntry(originalFile);
        boolean isAlreadyDeployed = originalFile.exists() && logEntry != null;
        IAddonDeployable unpackedDeployable = null;
        String lastModifiedOriginalFileName = null;
        try {
            lastModifiedOriginalFileName = FileUtils.lastModifiedFileName((File)originalFile);
        }
        catch (FileUtilsException e) {
            throw new DeployerException("Cannot get the last modified file name of " + originalFile.getAbsolutePath(), (Throwable)e);
        }
        if (logEntry != null && !lastModifiedOriginalFileName.equals(unpackedFileName = logEntry.getCopy().getName())) {
            logger.info((Object)"Deployable ''{0}'' has been updated.", new Object[]{deployable});
            archive = ArchiveManager.getInstance().getArchive((Object)((IAddonLogEntry)this.deployerLog.getEntry(originalFile)).getCopy());
            try {
                unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
            }
            catch (DeployableHelperException e) {
                throw new DeployerException("Cannot get the deployable " + originalFile, (Throwable)e);
            }
            AddonMetaData addonMetaData2 = null;
            try {
                addonMetaData2 = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), logEntry.getCopy().getAbsolutePath());
            }
            catch (Exception e) {
                logger.warn((Object)"Addon metadata are incorrect", new Object[0]);
            }
            try {
                this.deployerLog.removeEntry(this.deployerLog.getEntry(originalFile));
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Cannot remove log entry of the file " + originalFile.getAbsolutePath()), new Object[0]);
            }
            this.undeploy(unpackedDeployable, addonMetaData2);
            isAlreadyDeployed = false;
        }
        if (isAlreadyDeployed) {
            File unpackedFile2 = logEntry.getCopy();
            if (unpackedFile2 == null || !unpackedFile2.exists()) {
                File folder = new File(AddonUtil.getAddonsWorkDirectory(this.serverProperties));
                try {
                    unpackedDeployable = (IAddonDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)IAddonDeployable.class.cast(deployable)), (File)folder, (String)lastModifiedOriginalFileName, (boolean)false, (IDeployableHelper)this.deployableHelper);
                }
                catch (Exception e) {
                    throw new DeployerException("Cannot unpacked archive for '" + deployable.getArchive() + "'", (Throwable)e);
                }
            }
            archive = ArchiveManager.getInstance().getArchive((Object)((IAddonLogEntry)this.deployerLog.getEntry(originalFile)).getCopy());
            try {
                unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
            }
            catch (DeployableHelperException e) {
                throw new DeployerException("Cannot get the deployable " + originalFile, (Throwable)e);
            }
            logger.debug((Object)"Deploying ''{0}''", new Object[]{unpackedDeployable});
        } else {
            unpackedDeployable = null;
            File folder = new File(AddonUtil.getAddonsWorkDirectory(this.serverProperties));
            try {
                originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
                String archiveName = FileUtils.lastModifiedFileName((File)originalFile);
                unpackedDeployable = (IAddonDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)IAddonDeployable.class.cast(deployable)), (File)folder, (String)archiveName, (boolean)false, (IDeployableHelper)this.deployableHelper);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot deploy archive for '" + deployable.getArchive() + "'", (Throwable)e);
            }
            logger.info((Object)"Deploying ''{0}''", new Object[]{unpackedDeployable});
        }
        IArchive addonArchive = unpackedDeployable.getArchive();
        try {
            unpackedFile = URLUtils.urlToFile((URL)addonArchive.getURL());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get URL from archive '" + addonArchive + "'", (Throwable)e);
        }
        File addonMetadataFile = isAlreadyDeployed ? new File(AddonUtil.getAddonDirectoryPath(logEntry.getName()), "jonas-addon.xml") : AddonUtil.getAddonMetadataFile(addonArchive);
        this.validate(addonMetadataFile);
        try {
            addonMetaData = AddonUtil.getAddonMetadata(addonMetadataFile, unpackedFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Addon metadata are incorrect", (Throwable)e);
        }
        try {
            originalURL = deployable.getArchive().getURL();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the url of the initial deployable for the Addon Module '" + deployable + "'.", (Throwable)e);
        }
        this.checkAddonMetadata(addonMetaData);
        this.updateDeployables(unpackedFile.getAbsolutePath(), unpackedDeployable, addonMetaData);
        this.addons.put(originalURL, unpackedDeployable);
        if (this.deployerLog.getEntry(URLUtils.urlToFile((URL)originalURL)) != null) {
            this.deploy(unpackedDeployable, addonMetaData, true);
            logger.debug((Object)"''{0}'' addon is already deployed", new Object[]{deployable.getShortName()});
        } else {
            this.deploy(unpackedDeployable, addonMetaData, false);
            if (this.deployerLog != null) {
                try {
                    this.deployerLog.addEntry(addonMetaData.getName(), originalFile, unpackedFile);
                }
                catch (DeployerLogException e) {
                    logger.info((Object)"Cannot added a log entry to the addon logger", new Object[0]);
                }
            }
            this.deployedAddonNames.add(addonMetaData.getName());
            logger.info((Object)"''{0}'' addon is now deployed", new Object[]{deployable.getShortName()});
        }
        try {
            this.workCleanerLog.addEntry((LogEntry)new LogEntryImpl(originalFile, unpackedFile));
        }
        catch (DeployerLogException e) {
            logger.info((Object)"Cannot added a log entry to the addon work cleaner logger", new Object[0]);
        }
    }

    public void doUndeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        URL addonURL;
        logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            addonURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the Addon deployable '" + deployable + "'.", (Throwable)e);
        }
        IAddonDeployable unpackedDeployable = null;
        if (!this.addons.containsKey(addonURL)) {
            throw new DeployerException("Cannot get the URL of the unpacked Addon deployable '" + deployable + "'.");
        }
        unpackedDeployable = this.addons.get(addonURL);
        File unpackedDeployableFile = null;
        try {
            unpackedDeployableFile = URLUtils.urlToFile((URL)unpackedDeployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the unpacked deployable '" + unpackedDeployable + "'.", (Throwable)e);
        }
        AddonMetaData addonMetaData = null;
        try {
            addonMetaData = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), unpackedDeployableFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.warn((Object)"Addon metadata are incorrect", new Object[]{e});
        }
        File originalFile = URLUtils.urlToFile((URL)addonURL);
        IAddonLogEntry logEntry = (IAddonLogEntry)this.deployerLog.getEntry(originalFile);
        if (logEntry != null) {
            try {
                this.deployerLog.removeEntry((LogEntry)logEntry);
            }
            catch (DeployerLogException e) {
                logger.error((Object)"Cannot remove the LogEntry", new Object[0]);
            }
        }
        this.undeploy(unpackedDeployable, addonMetaData);
        this.deployedAddonNames.remove(addonMetaData.getName());
        this.addons.remove(addonURL);
        logger.info((Object)"''{0}'' addon is now undeployed", new Object[]{deployable.getShortName()});
    }

    public boolean supports(IDeployable<?> deployable) {
        return AddonDeployableImpl.class.isInstance(deployable);
    }

    private void checkAddonMetadata(AddonMetaData addonMetaData) throws DeployerException {
        if (this.deployedAddonNames.contains(addonMetaData.getName())) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. An Addon with the same " + "name is already deployed.");
        }
        String JOnASVersion = Version.getNumber();
        if (!addonMetaData.isJOnASVersionSupported(JOnASVersion)) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. JOnAS version " + JOnASVersion + " doesn't match ");
        }
        String jvmVersion = System.getProperty("java.version");
        if (!addonMetaData.isJvmVersionSupported(jvmVersion)) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. JVM version " + jvmVersion + " doesn't match ");
        }
    }

    private void deploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData, boolean isAlreadyDeployed) throws DeployerException {
        List<IDeployable<?>> failed;
        if (!isAlreadyDeployed) {
            this.confDeployer.deploy(unpackedDeployable, addonMetaData);
        }
        ArrayList<ISortableDeployable> allDeployables = new ArrayList<ISortableDeployable>();
        allDeployables.addAll(unpackedDeployable.getDeployables());
        if (!allDeployables.isEmpty() && !(failed = this.deploySortableDeployables(allDeployables)).isEmpty()) {
            throw new DeployerException("The addon " + addonMetaData.getName() + " cannot be deployed");
        }
        String service = addonMetaData.getService();
        if (service != null && addonMetaData.getAutostart().booleanValue()) {
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("service", service);
            this.serviceRegistrations.add(this.bundleContext.registerService(ServiceProperties.class.getName(), (Object)addonMetaData.getServiceProperties(), dictionary));
            try {
                this.serviceManager.startService(service, false);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot create the configuration for the service " + service, (Throwable)e);
            }
        }
    }

    private void undeploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData) throws DeployerException {
        List<IDeployable<?>> failed;
        this.confDeployer.undeploy(unpackedDeployable.getArchive(), addonMetaData, this.deployerLog);
        String service = addonMetaData.getService();
        if (service != null && addonMetaData.getAutostart().booleanValue()) {
            try {
                this.serviceManager.stopService(service);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot delete the configuration for the service " + service, (Throwable)e);
            }
            ServiceRegistration serviceRegistration = AddonUtil.getServiceRegistration(this.serviceRegistrations, "service", addonMetaData.getService());
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
                this.serviceRegistrations.remove(serviceRegistration);
            }
        }
        ArrayList<ISortableDeployable> allDeployables = new ArrayList<ISortableDeployable>();
        allDeployables.addAll(unpackedDeployable.getDeployables());
        if (!allDeployables.isEmpty() && !(failed = this.undeploySortableDeployables(allDeployables)).isEmpty()) {
            throw new DeployerException("The addon " + addonMetaData.getName() + " cannot be undeployed");
        }
    }

    private void retrieveJOnASConfiguration(Map<String, String> addonsToUndeploy) {
        this.confDeployer.retrieveJOnASConfiguration(this.deployerLog, addonsToUndeploy, true);
        for (Map.Entry<String, String> entry : addonsToUndeploy.entrySet()) {
            String unpackedDeployablePath = entry.getValue();
            IAddonDeployable unpackedDeployable = (IAddonDeployable)AddonUtil.getDeployable(this.deployableHelper, new File(unpackedDeployablePath));
            this.updateDeployables(unpackedDeployablePath, unpackedDeployable);
            List sortableDeployables = unpackedDeployable.getDeployables();
            if (sortableDeployables == null) continue;
            ArrayList<ISortableDeployable> persistentSortableDeployable = new ArrayList<ISortableDeployable>();
            for (ISortableDeployable sortableDeployable : sortableDeployables) {
                IDeployable deployable = sortableDeployable.getDeployable();
                if (!(deployable instanceof OSGiDeployable)) continue;
                persistentSortableDeployable.add(sortableDeployable);
            }
            List<IDeployable<?>> failed = this.undeploySortableDeployables(persistentSortableDeployable);
            if (failed.isEmpty()) continue;
            logger.error((Object)("The addon " + entry.getKey() + " cannot be undeployed"), new Object[0]);
        }
    }

    public void updateDeployables(String unpackedDeployablePath, IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData) {
        File addonDeployWorkDirectory = new File(AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath));
        if (addonDeployWorkDirectory.isDirectory()) {
            for (File file : addonDeployWorkDirectory.listFiles()) {
                IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, file);
                ISortableDeployable sortableDeployable = AddonUtil.getSortableDeployable(deployable);
                if (deployable instanceof DeploymentPlanDeployable) {
                    String service = addonMetaData.getService();
                    if (service != null) {
                        String implementation;
                        File urlInternalDirectory = new File(AddonUtil.JONAS_ROOT_URL_INTERNAL_DIRECTORY);
                        if (!urlInternalDirectory.exists()) {
                            urlInternalDirectory.getParentFile().mkdirs();
                        }
                        if ((implementation = addonMetaData.getImplementation()) == null) {
                            String defaultDeploymentPlanName = AddonUtil.getDefaultDeploymentPlan(service);
                            File defaultDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), defaultDeploymentPlanName);
                            if (defaultDeploymentPlan.exists()) {
                                AddonUtil.copyFile(defaultDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), defaultDeploymentPlanName));
                            }
                        } else {
                            File jonasDeploymentPlanImpl;
                            String jonasAbstractDeploymentPlanName = AddonUtil.getAbstractDeploymentPlan(service);
                            String jonasDeploymentPlanImplName = AddonUtil.getImplDeploymentPlan(service, implementation);
                            File jonasAbstractDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName);
                            if (jonasAbstractDeploymentPlan.exists()) {
                                AddonUtil.copyFile(jonasAbstractDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName));
                            }
                            if ((jonasDeploymentPlanImpl = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasDeploymentPlanImplName)).exists()) {
                                AddonUtil.copyFile(jonasDeploymentPlanImpl, new File(urlInternalDirectory.getAbsolutePath(), jonasDeploymentPlanImplName));
                            }
                        }
                    }
                    unpackedDeployable.addDeployable(sortableDeployable);
                    continue;
                }
                if (deployable instanceof UnknownDeployable) continue;
                unpackedDeployable.addDeployable(sortableDeployable);
            }
        }
    }

    public void updateDeployables(String unpackedDeployablePath, IAddonDeployable unpackedDeployable) {
        File addonDeployWorkDirectory = new File(AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath));
        if (addonDeployWorkDirectory.isDirectory()) {
            for (File file : addonDeployWorkDirectory.listFiles()) {
                IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, file);
                ISortableDeployable sortableDeployable = AddonUtil.getSortableDeployable(deployable);
                if (deployable instanceof UnknownDeployable) continue;
                unpackedDeployable.addDeployable(sortableDeployable);
            }
        }
    }

    private List<IDeployable<?>> deploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        AddonUtil.sortSortableDeployable(sortableDeployables);
        ArrayList deployables = new ArrayList();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            IDeployable deployable = sortableDeployable.getDeployable();
            try {
                if (this.deployerManager.isDeployed(deployable)) continue;
                deployables.add(sortableDeployable.getDeployable());
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not find if the deployable " + deployable.getShortName() + " is already deployed"), new Object[]{e});
            }
            catch (UnsupportedDeployerException e) {
                logger.error((Object)("Could not find if the deployable " + deployable.getShortName() + " is already deployed"), new Object[]{e});
            }
        }
        try {
            return this.deployerManager.deploy(deployables);
        }
        catch (UnsupportedDeployerException e) {
            return deployables;
        }
    }

    private List<IDeployable<?>> undeploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        AddonUtil.sortSortableDeployable(sortableDeployables);
        Collections.reverse(sortableDeployables);
        ArrayList deployables = new ArrayList();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            deployables.add(sortableDeployable.getDeployable());
        }
        try {
            return this.deployerManager.undeploy(deployables);
        }
        catch (UnsupportedDeployerException e) {
            return deployables;
        }
    }

    public boolean isAddonDeployedByWorkName(String unpackName) {
        if (!this.isInitialized()) {
            return true;
        }
        for (IAddonDeployable addonDeployable : this.addons.values()) {
            try {
                File unpackedFile = URLUtils.urlToFile((URL)addonDeployable.getArchive().getURL());
                if (!unpackName.equals(unpackedFile.getName())) continue;
                return true;
            }
            catch (ArchiveException e) {
                logger.debug((Object)"Cannot retrieve the name of the unpacked addon {0}", new Object[]{unpackName});
            }
        }
        return false;
    }

    private boolean isInitialized() {
        if (!this.isInitialized) {
            int deployerLogSize = this.deployerLog.getEntries().size();
            this.isInitialized = deployerLogSize == 0 || deployerLogSize == this.addons.size();
        }
        return this.isInitialized;
    }

    private void validate(File addonMetadataFile) throws DeployerException {
        InputStream xsdInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(XSD_RESOURCE);
        if (xsdInputStream != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = factory.newSchema(new StreamSource(xsdInputStream));
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot create a new Schema from the resource /META-INF/jonas-addon-1.0.xsd", (Throwable)e);
            }
            Validator validator = schema.newValidator();
            DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
            xmlFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            try {
                builder = xmlFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new DeployerException("Cannot create a new DocumentBuilder", (Throwable)e);
            }
            Document document = null;
            try {
                document = builder.parse(addonMetadataFile);
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot parse the file " + addonMetadataFile.getAbsolutePath(), (Throwable)e);
            }
            catch (IOException e) {
                throw new DeployerException("Cannot parse the file " + addonMetadataFile.getAbsolutePath(), (Throwable)e);
            }
            try {
                validator.validate(new DOMSource(document));
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot validate the file " + addonMetadataFile.getAbsolutePath() + " from the XSD " + "resource " + XSD_RESOURCE, (Throwable)e);
            }
            catch (IOException e) {
                throw new DeployerException("Cannot validate the Node " + addonMetadataFile.getAbsolutePath() + " from the XSD " + "resource " + XSD_RESOURCE, (Throwable)e);
            }
        }
        throw new DeployerException("Cannot get the inputstream of the resource /META-INF/jonas-addon-1.0.xsd");
    }
}

