/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.felix.shell.ShellService;
import org.apache.felix.shell.gui.Plugin;
import org.apache.felix.shell.gui.plugin.OutputAreaStream;
import org.apache.felix.shell.gui.plugin.ScrollableOutputArea;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ShellPlugin
extends JPanel
implements Plugin {
    private BundleContext m_context = null;
    private PrintStream m_out = null;
    private JTextField m_commandField = new JTextField();
    private String[] m_history = new String[25];
    private int m_historyCount = -1;
    private int m_current = 0;
    private ScrollableOutputArea m_soa = new ScrollableOutputArea();

    public String getName() {
        return "Shell";
    }

    public Component getGUI() {
        return this;
    }

    public ShellPlugin(BundleContext context) {
        this.m_context = context;
        this.m_out = new PrintStream(new OutputAreaStream(this.m_soa));
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.m_commandField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                ShellPlugin.this.commandFieldKeyPressed(event);
            }
        });
        this.m_commandField.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.m_commandField, "South");
        this.add((Component)this.m_soa, "Center");
    }

    void processCommand(String line) {
        if (line == null) {
            return;
        }
        if ((line = line.trim()).length() == 0) {
            return;
        }
        ServiceReference ref = this.m_context.getServiceReference(ShellService.class.getName());
        if (ref == null) {
            this.m_out.println("No shell service is available.");
            return;
        }
        ShellService shell = (ShellService)this.m_context.getService(ref);
        this.m_out.println("-> " + line);
        try {
            shell.executeCommand(line, this.m_out, this.m_out);
        }
        catch (Exception ex) {
            this.m_out.println(ex.toString());
            ex.printStackTrace(this.m_out);
        }
        this.m_context.ungetService(ref);
    }

    private void addToHistory(String command) {
        ++this.m_historyCount;
        if (this.m_historyCount >= this.m_history.length) {
            this.m_historyCount = this.m_history.length - 1;
            for (int i = 0; i < this.m_history.length - 1; ++i) {
                this.m_history[i] = this.m_history[i + 1];
            }
        }
        this.m_history[this.m_historyCount] = new String(command);
    }

    private String getFromHistory(int num) {
        if (num < 0) {
            return "";
        }
        if (num > this.m_historyCount) {
            return "";
        }
        return this.m_history[num];
    }

    protected void commandFieldKeyPressed(KeyEvent event) {
        String command = null;
        int c = event.getKeyCode();
        if (c == 38) {
            --this.m_current;
            if (this.m_current < 0) {
                this.m_current = 0;
            }
            this.m_commandField.setText(this.getFromHistory(this.m_current));
            this.m_commandField.setCaretPosition(this.m_commandField.getText().length());
        } else if (c == 40) {
            ++this.m_current;
            if (this.m_current > this.m_historyCount) {
                this.m_current = this.m_historyCount + 1;
            }
            this.m_commandField.setText(this.getFromHistory(this.m_current));
            this.m_commandField.setCaretPosition(this.m_commandField.getText().length());
        } else if (c == 10) {
            command = this.m_commandField.getText();
            if (!command.equals("")) {
                this.addToHistory(command);
                this.m_current = this.m_historyCount + 1;
                this.processCommand(command);
            }
            this.m_commandField.setText("");
        }
    }
}

