/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.rdbsequence;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionIO;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.lib.RdbConnectionWrapper;
import org.objectweb.util.monolog.api.Logger;

public class RdbSequenceHelper {
    private String nextValRequest;
    private RdbAdapter adapter;
    private String seqName;
    private Integer seqStart = null;
    private Integer seqIncrement = null;
    private Integer seqCache = null;
    private boolean created;
    private Logger logger;

    public RdbSequenceHelper() {
    }

    public RdbSequenceHelper(RdbAdapter adapter, String seqName, boolean sequenceCreated) {
        this();
        this.setAdapter(adapter);
        this.setSequenceName(seqName);
        this.setSequenceCreated(sequenceCreated);
    }

    public void setSequenceCreated(boolean sequencecreated) {
        this.created = sequencecreated;
    }

    public boolean isSequenceCreated() {
        return this.created;
    }

    public void setSequenceName(String seqName) {
        this.seqName = seqName;
    }

    public String getSequenceName() {
        return this.seqName;
    }

    public RdbAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(RdbAdapter adapter) {
        this.adapter = adapter;
    }

    public Integer getSequenceStart() {
        return this.seqStart;
    }

    public void setSequenceStart(Integer seqStart) {
        this.seqStart = seqStart;
    }

    public Integer getSequenceIncrement() {
        return this.seqIncrement;
    }

    public void setSequenceIncrement(Integer seqIncrement) {
        this.seqIncrement = seqIncrement;
    }

    public Integer getSequenceCache() {
        return this.seqCache;
    }

    public void setSequenceCache(Integer seqCache) {
        this.seqCache = seqCache;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * Loose catch block
     */
    public synchronized boolean createSequence(Object c) throws PException {
        boolean bl;
        Statement s;
        block14: {
            block12: {
                boolean bl2;
                block13: {
                    if (this.created) {
                        return false;
                    }
                    if (this.seqName == null) {
                        throw new PException("No sequence name specified");
                    }
                    if (this.adapter == null) {
                        throw new PException("No RdbAdapter specified");
                    }
                    Connection conn = RdbConnectionWrapper.narrow2SQL(c);
                    this.created = true;
                    s = null;
                    if (this.adapter.existSequence(conn, this.seqName)) break block12;
                    s = conn.createStatement();
                    s.execute(this.adapter.getCreateSequence(this.seqName, this.seqStart, this.seqIncrement, this.seqCache));
                    bl2 = true;
                    Object var6_7 = null;
                    if (s == null) break block13;
                    try {
                        s.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = false;
            Object var6_8 = null;
            if (s == null) break block14;
            try {
                s.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e) {
            try {
                this.created = false;
                throw new PExceptionIO(e, "Impossible to create the sequence '" + this.seqName + "'.");
            }
            catch (Throwable throwable) {
                block15: {
                    Object var6_9 = null;
                    if (s == null) break block15;
                    try {
                        s.close();
                    }
                    catch (SQLException e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long allocateId(Object c) throws PException {
        if (this.nextValRequest == null) {
            if (this.seqName == null) {
                throw new PException("No sequence name specified");
            }
            if (this.adapter == null) {
                throw new PException("No RdbAdapter specified");
            }
            if (!this.created) {
                throw new PException("Protocol Error: You have to ask the sequence creation before id allocation");
            }
            this.nextValRequest = this.adapter.getNextValInSequence(this.seqName);
        }
        Connection conn = RdbConnectionWrapper.narrow2SQL(c);
        Statement s = null;
        ResultSet rs = null;
        long res = -1L;
        try {
            try {
                s = conn.createStatement();
                rs = s.executeQuery(this.nextValRequest);
                if (!rs.next()) throw new PExceptionIO("Strong case: The nextval operation does not return any value!");
                res = rs.getLong(1);
                Object var9_6 = null;
            }
            catch (SQLException e) {
                throw new PExceptionIO(e, "Impossible to allocate a new identifier on the sequence: " + this.seqName);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (s == null) throw throwable;
                s.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (rs != null) {
            rs.close();
        }
        if (s == null) return res;
        s.close();
        return res;
    }

    public boolean allocateHint(Object c, int numberOfNextVal) throws PException {
        if (this.seqName == null) {
            throw new PException("No sequence name specified");
        }
        if (this.adapter == null) {
            throw new PException("No RdbAdapter specified");
        }
        if (!this.created) {
            throw new PException("Protocol Error: You have to ask the sequence creation before id allocation");
        }
        try {
            Connection conn = RdbConnectionWrapper.narrow2SQL(c);
            this.adapter.getManyNextValInSequence(conn, this.seqName, numberOfNextVal);
        }
        catch (RdbAdapterException ae) {
            throw new PException(ae, "Cannot allocate hint");
        }
        return true;
    }
}

