/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.lib;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapCluster;
import org.objectweb.jorm.mapper.rdb.lib.MapperJDBC;
import org.objectweb.jorm.mapper.rdb.lib.RdbScriptPMSM;

public class AntScriptGenerator
extends MatchingTask {
    public static final String SCRIPT_FILE_NAME = "script.fileName";
    public static final String SCRIPT_MAPPER_NAME = "script.mapperName";
    public static final String SCRIPT_DELETE_STATEMENT = "script.generate.delete";
    public static final String SCRIPT_DROP_STATEMENT = "script.generate.drop";
    public static final String SCRIPT_CREATE_STATEMENT = "script.generate.create";
    public static final String SCRIPT_CLASS_DIR = "script.class.dir";
    public static final String SCRIPT_JAR_DIR = "script.jar.dir";
    private Path classpath = null;
    private File src = null;
    protected File destFile = null;
    private String mapperName;
    protected boolean generateDrop = true;
    protected boolean generateDelete = true;
    protected boolean generateCreate = true;
    private String userDefinedIncludes = null;
    protected RdbScriptPMSM msm = null;
    protected List classesToProcess = null;
    protected boolean uptodate = false;
    protected ClassLoader classLoader = null;

    public static void main(String[] args) {
        new AntScriptGenerator().execute(args);
    }

    public RdbScriptPMSM getRdbScriptPMSM() {
        return this.msm;
    }

    public List getClassesToProcess() {
        return this.classesToProcess;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setSrc(File src) {
        this.src = src;
    }

    public File getSrc() {
        return this.src;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setGenerateDrop(boolean generate) {
        this.generateDrop = generate;
    }

    public boolean isGenerateDrop() {
        return this.generateDrop;
    }

    public void setGenerateDelete(boolean generate) {
        this.generateDelete = generate;
    }

    public boolean isGenerateDelete() {
        return this.generateDelete;
    }

    public void setGenerateCreate(boolean generate) {
        this.generateCreate = generate;
    }

    public boolean isGenerateCreate() {
        return this.generateCreate;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public void setMapperName(String mapperName) {
        this.mapperName = mapperName;
    }

    public DirectoryScanner getDirectoryScanner() {
        return super.getDirectoryScanner(this.src);
    }

    public void setIncludes(String s) {
        super.setIncludes(s);
        this.userDefinedIncludes = s;
    }

    public void execute() {
        try {
            int i;
            if (this.userDefinedIncludes == null) {
                super.setIncludes("**/*Mapping.class");
                this.userDefinedIncludes = "**/*Mapping.class";
            }
            String[] ifs = this.getDirectoryScanner().getIncludedFiles();
            this.classesToProcess = Arrays.asList(ifs);
            if (this.classesToProcess == null || this.classesToProcess.isEmpty()) {
                this.log("No class files found in " + this.src.getAbsolutePath() + ".", 4);
                return;
            }
            UpToDate u = new UpToDate();
            u.setProject(this.getProject());
            FileSet fs = new FileSet();
            fs.setDir(this.src);
            fs.setIncludes(this.userDefinedIncludes);
            u.addSrcfiles(fs);
            u.setTargetFile(this.destFile);
            if (u.eval()) {
                this.uptodate = true;
                return;
            }
            ArrayList<String> tmpClasses = new ArrayList<String>(this.classesToProcess.size());
            for (int i2 = 0; i2 < this.classesToProcess.size(); ++i2) {
                tmpClasses.add(AntScriptGenerator.formatElement((String)this.classesToProcess.get(i2)));
            }
            this.msm = new RdbScriptPMSM(this.destFile.getAbsolutePath(), true);
            try {
                MapperJDBC mapper = new MapperJDBC();
                mapper.setMapperName(this.mapperName);
                mapper.start();
                this.msm.setPMapper(mapper);
                this.msm.init();
            }
            catch (PException pe) {
                this.log("[ERROR] Impossible to init the PMappingStructuresManager: " + pe.getMessage(), 0);
            }
            URL[] urls = new URL[this.classpath.list().length];
            for (i = 0; i < urls.length; ++i) {
                urls[i] = new File(this.classpath.list()[i]).isDirectory() ? new URL("file://" + this.classpath.list()[i] + "/") : new URL("file://" + this.classpath.list()[i]);
            }
            this.classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
            this.classesToProcess = new ArrayList(tmpClasses);
            for (i = 0; i < this.classesToProcess.size(); ++i) {
                if (this.initClass((String)this.classesToProcess.get(i), this.msm, this.classLoader) != -1) continue;
                tmpClasses.remove(this.classesToProcess.get(i));
            }
            this.classesToProcess = new ArrayList(tmpClasses);
            ArrayList<PMapCluster> clusterList = new ArrayList<PMapCluster>(1);
            for (int i3 = 0; i3 < this.classesToProcess.size(); ++i3) {
                try {
                    PMapCluster cluster;
                    String classMapping;
                    String className = classMapping = (String)this.classesToProcess.get(i3);
                    int index = classMapping.indexOf("Mapping");
                    if (index != -1) {
                        className = classMapping.substring(0, index);
                    }
                    if ((cluster = this.msm.getPMapCluster(className)) == null) {
                        this.log("[ERROR] JORM cluster is null for class: " + className, 0);
                    }
                    if (clusterList.contains(cluster)) continue;
                    clusterList.add(cluster);
                    if (!cluster.isDefined()) {
                        Iterator it = cluster.getUnResolvedDependencies().iterator();
                        while (it.hasNext()) {
                            String classUnresolved = (String)it.next();
                            if (className.equals(classUnresolved)) {
                                cluster.classDefined(className);
                                continue;
                            }
                            this.log("[INFO] Cluster for class: " + className + " is not ready : " + cluster.getUnResolvedDependencies().toString(), 2);
                            this.initClass(classUnresolved + "Mapping", this.msm, this.classLoader);
                        }
                    }
                    if (this.generateDrop) {
                        cluster.deleteMappingStructures();
                    }
                    if (this.generateCreate) {
                        cluster.createMappingStructures(true);
                    }
                    if (!this.generateDelete) continue;
                    cluster.deleteData();
                    continue;
                }
                catch (Exception pe) {
                    this.log("[ERROR] Cannot generate sql statements : " + pe.getMessage(), 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute(String[] args) {
        String createString;
        String dropString;
        String deleteString;
        if (args.length == 0) {
            this.usage("You must specify classes to generate script for.");
        }
        this.destFile = new File(System.getProperty(SCRIPT_FILE_NAME));
        if (this.destFile == null) {
            this.usage("You must specify a destination file.");
        }
        this.mapperName = System.getProperty(SCRIPT_MAPPER_NAME);
        if (this.mapperName == null) {
            this.usage("You must specify a mapper name.");
        }
        if ((deleteString = System.getProperty(SCRIPT_DELETE_STATEMENT)) != null) {
            this.generateDelete = new Boolean(deleteString);
        }
        if ((dropString = System.getProperty(SCRIPT_DROP_STATEMENT)) != null) {
            this.generateDrop = new Boolean(dropString);
        }
        if ((createString = System.getProperty(SCRIPT_CREATE_STATEMENT)) != null) {
            this.generateCreate = new Boolean(createString);
        }
    }

    private int initClass(String className, RdbScriptPMSM msm, ClassLoader classLoader) {
        Class<?> currentClass = null;
        try {
            currentClass = classLoader.loadClass(className);
            Object o = currentClass.newInstance();
            PClassMapping pcm = (PClassMapping)o;
            pcm.init(msm);
        }
        catch (ClassNotFoundException e) {
            this.log("[ERROR] Impossible to load the persistent class '" + className + "' from the classpath: " + e.getMessage(), 0);
            return -1;
        }
        catch (IllegalAccessException iae) {
            this.log("[ERROR] Impossible to have access to a new instance of the class '" + className + ": " + iae.getMessage(), 0);
            return -1;
        }
        catch (InstantiationException ie) {
            this.log("[ERROR] Impossible to get a new instance of the class '" + className + ": " + ie.getMessage(), 0);
            return -1;
        }
        catch (PException pe) {
            this.log("[ERROR] Impossible to init the PClassMapping class '" + className + ": " + pe.getMessage(), 0);
            return -1;
        }
        return 1;
    }

    private void usage(String msg) {
        this.log(msg, 0);
        this.log("Usage: ", 0);
        this.log("\tRdbScriptGeneration (<class name to generate>)*", 0);
        this.log("\t\t-Dscript.class.dir=<generated classes directory>", 0);
        this.log("\t\t-Dscript.jar.dir=<added jar directory>", 0);
        this.log("\t\t[-Dscript.fileName=<file name>]", 0);
        this.log("\t\t[-Dscript.mapperName=<mapper name>]", 0);
        this.log("\t\t[-Dscript.generate.delete=<true|false>]", 0);
        this.log("\t\t[-Dscript.generate.drop=<true|false>]", 0);
        this.log("\t\t[-Dscript.generate.create=<true|false>]", 0);
        System.exit(1);
    }

    public static String formatElement(String element) {
        int index = element.lastIndexOf(".");
        if (index != -1) {
            element = element.substring(0, index);
        }
        element = element.indexOf("\\") != -1 ? AntScriptGenerator.replaceString("\\", ".", element) : AntScriptGenerator.replaceString("/", ".", element);
        return element;
    }

    public static String replaceString(String old, String neo, String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int oldSize = old.length();
        int neoSize = neo.length();
        StringBuffer sb = new StringBuffer(str);
        int begin = 0;
        int idx = sb.indexOf(old, begin);
        while (idx != -1) {
            sb.delete(idx, idx + oldSize);
            sb.insert(idx, neo);
            begin = idx + neoSize;
            if (begin < sb.length()) {
                idx = sb.indexOf(old, begin);
                continue;
            }
            idx = -1;
        }
        return sb.toString();
    }
}

