/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployerLog;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.impl.util.AddonLogEntry;
import org.ow2.jonas.lib.work.AbsDeployerLog;
import org.ow2.jonas.workcleaner.DeployerLogException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonDeployerLog
extends AbsDeployerLog<IAddonLogEntry>
implements IAddonDeployerLog<IAddonLogEntry> {
    public AddonDeployerLog(File logFile) throws DeployerLogException {
        super(logFile);
    }

    protected synchronized void loadEntries() throws DeployerLogException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.logFile));
        }
        catch (FileNotFoundException e) {
            throw new DeployerLogException("Can not read the " + this.logFile + " file");
        }
        String line = null;
        String field = null;
        String name = null;
        File originalField = null;
        File copyField = null;
        StringTokenizer st = null;
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, ";");
                name = st.nextToken();
                if (name == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                originalField = new File(field);
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                copyField = new File(field);
                this.logger.debug((Object)("Entry[originalField=" + originalField + ",copyField=" + copyField + "]"), new Object[0]);
                AddonLogEntry addonLogEntry = new AddonLogEntry(name, originalField, copyField);
                this.logEntries.add(addonLogEntry);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new DeployerLogException("Error while reading the log file " + this.logFile + " :" + ioe.getMessage());
        }
    }

    protected synchronized void saveEntries() throws DeployerLogException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(this.logFile)));
        }
        catch (IOException e) {
            throw new DeployerLogException("Problem while trying to get an output stream for the " + this.logFile + " file");
        }
        IAddonLogEntry logEntry = null;
        String name = null;
        String original = null;
        String copy = null;
        String line = null;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements()) {
            logEntry = (IAddonLogEntry)e.nextElement();
            try {
                name = logEntry.getName();
                original = logEntry.getOriginal().getCanonicalPath();
                copy = logEntry.getCopy().getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new DeployerLogException("Problem while trying to get files names ");
            }
            line = name + ";" + original + ";" + copy;
            pw.println(line);
        }
        pw.close();
    }

    public Vector<IAddonLogEntry> addEntry(IAddonLogEntry logEntry) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not add an entry, the vector is null");
        }
        String name = null;
        File originalEntry = null;
        File copyEntry = null;
        boolean found = false;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements() && !found) {
            IAddonLogEntry entry = (IAddonLogEntry)e.nextElement();
            name = entry.getName();
            originalEntry = entry.getOriginal();
            copyEntry = entry.getCopy();
            if (!originalEntry.getPath().equals(logEntry.getOriginal().getPath()) || !copyEntry.getPath().equals(logEntry.getCopy().getPath()) || !name.equals(logEntry.getName())) continue;
            found = true;
        }
        if (found) {
            return this.logEntries;
        }
        this.logEntries.add(logEntry);
        this.saveEntries();
        return this.logEntries;
    }

    public synchronized Vector<IAddonLogEntry> addEntry(String name, File original, File copy) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not add an entry, the vector is null");
        }
        return this.addEntry(new AddonLogEntry(name, original, copy));
    }

    public IAddonLogEntry getEntry(File original) {
        for (IAddonLogEntry logEntry : this.logEntries) {
            if (!logEntry.getOriginal().equals(original)) continue;
            return logEntry;
        }
        return null;
    }
}

