/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import jline.console.completer.Completer;
import org.apache.felix.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeCompleter
implements Completer {
    private Completer delegate;
    private CommandSession session;

    public ScopeCompleter(Completer delegate, CommandSession session) {
        this.delegate = delegate;
        this.session = session;
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        TreeMap<Integer, ArrayList<ArrayList<CharSequence>>> completions = new TreeMap<Integer, ArrayList<ArrayList<CharSequence>>>();
        String scopeValue = (String)this.session.get("SCOPE");
        if (scopeValue != null) {
            String[] scopes;
            for (String scope : scopes = scopeValue.split(":")) {
                ArrayList<CharSequence> subCandidates = new ArrayList<CharSequence>(candidates);
                int value = this.delegate.complete(scope + ":" + buffer, (scope + ":").length() + cursor, subCandidates);
                ArrayList<ArrayList<CharSequence>> completionResult = (ArrayList<ArrayList<CharSequence>>)completions.get(value);
                if (completionResult == null) {
                    completionResult = new ArrayList<ArrayList<CharSequence>>();
                    completions.put(value, completionResult);
                }
                completionResult.add(subCandidates);
            }
            int max = (Integer)completions.lastKey();
            List listOfCandidates = (List)completions.get(max);
            for (List selectedCandidates : listOfCandidates) {
                candidates.addAll(selectedCandidates);
            }
            return max;
        }
        return -1;
    }
}

