/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilAdmin {
    public static final String ALL = ",*";
    public static final String J2EEServer = "J2EEServer";
    public static final String ServerProxy = "ServerProxy";
    public static final String J2EEType = "j2eeType";
    public static final String Type = "type";
    public static final String ServiceType = "service";

    private UtilAdmin() {
    }

    private static ObjectName getJ2eeMBean(String domain, String server, String type) throws MalformedObjectNameException {
        StringBuilder sb = new StringBuilder(domain);
        sb.append(":");
        sb.append(J2EEServer);
        sb.append("=");
        sb.append(server);
        sb.append(",");
        sb.append(J2EEType);
        sb.append("=");
        sb.append(type);
        sb.append(ALL);
        return ObjectName.getInstance(sb.toString());
    }

    protected static ObjectName getJ2eeMBean(String domain, String server, String type, String name) throws MalformedObjectNameException {
        StringBuilder sb = new StringBuilder(domain);
        sb.append(":");
        sb.append(J2EEServer);
        sb.append("=");
        sb.append(server);
        sb.append(",");
        sb.append(J2EEType);
        sb.append("=");
        sb.append(type);
        sb.append(",");
        sb.append("name=");
        sb.append(name);
        return ObjectName.getInstance(sb.toString());
    }

    public static ObjectName J2EEServer(String serverName) throws MalformedObjectNameException, NullPointerException {
        StringBuilder sb = new StringBuilder("*");
        sb.append(":");
        sb.append(J2EEType);
        sb.append("=");
        sb.append(J2EEServer);
        sb.append(",");
        sb.append("name");
        sb.append("=");
        sb.append(serverName);
        return ObjectName.getInstance(sb.toString());
    }

    public static ObjectName ServerProxy(String serverName) throws MalformedObjectNameException, NullPointerException {
        StringBuilder sb = new StringBuilder("*");
        sb.append(":");
        sb.append(Type);
        sb.append("=");
        sb.append(ServerProxy);
        sb.append(",");
        sb.append("name");
        sb.append("=");
        sb.append(serverName);
        return ObjectName.getInstance(sb.toString());
    }

    private static ObjectName J2EEServer(String domain, String server) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EEType, J2EEServer);
        table.put("name", server);
        return UtilAdmin.getObjectName(domain, table);
    }

    public static ObjectName getJonasServiceMBean(String domain, String server, String service) throws MalformedObjectNameException, NullPointerException {
        StringBuilder sb = new StringBuilder(domain);
        sb.append(":");
        sb.append(Type);
        sb.append("=");
        sb.append(ServiceType);
        sb.append(",");
        sb.append("name");
        sb.append("=");
        sb.append(service);
        sb.append(ALL);
        return ObjectName.getInstance(sb.toString());
    }

    public static ObjectName getJonasServiceMBean(String domain, String server, String service, Properties keyProps) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(Type, ServiceType);
        table.put("name", service);
        if (keyProps != null) {
            Enumeration<Object> keys = keyProps.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = keyProps.getProperty(key);
                table.put(key, value);
            }
        }
        return UtilAdmin.getObjectName(domain, table);
    }

    private static ObjectName getObjectName(String domain, Hashtable<String, String> table) throws MalformedObjectNameException, NullPointerException {
        return ObjectName.getInstance(domain, table);
    }

    public static ArrayList<String> listBeans(String domain, String server, MBeanServerConnection conn) throws MalformedObjectNameException, IOException {
        String type = "EntityBean";
        ObjectName ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        type = "StatefulSessionBean";
        ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        Set<ObjectName> nextSet = conn.queryNames(ons, null);
        onSet.addAll(nextSet);
        type = "StatelessSessionBean";
        ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        nextSet = conn.queryNames(ons, null);
        onSet.addAll(nextSet);
        type = "MessageDrivenBean";
        ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        nextSet = conn.queryNames(ons, null);
        onSet.addAll(nextSet);
        Iterator<ObjectName> it = onSet.iterator();
        ArrayList<String> nameList = new ArrayList<String>();
        while (it.hasNext()) {
            ObjectName on = it.next();
            String name = on.getKeyProperty("name");
            String module = on.getKeyProperty("EJBModule");
            String printable = module.concat(": ");
            printable = printable.concat(name);
            nameList.add(printable);
        }
        return nameList;
    }

    protected static ArrayList<String> listModules(String domain, String server, MBeanServerConnection conn) throws MalformedObjectNameException, IOException {
        String type = "EJBModule";
        ObjectName ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        type = "WebModule";
        ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        Set<ObjectName> nextSet = conn.queryNames(ons, null);
        onSet.addAll(nextSet);
        type = "ResourceAdaperModule";
        nextSet = conn.queryNames(ons, null);
        onSet.addAll(nextSet);
        Iterator<ObjectName> it = onSet.iterator();
        ArrayList<String> nameList = new ArrayList<String>();
        while (it.hasNext()) {
            ObjectName on = it.next();
            String name = on.getKeyProperty("name");
            String appName = on.getKeyProperty("J2EEApplication");
            String printable = null;
            printable = appName != null && appName.equals("none") ? appName.concat(": ") : "";
            printable = printable.concat(name);
            nameList.add(printable);
        }
        return nameList;
    }

    protected static ArrayList<String> listApps(String domain, String server, MBeanServerConnection conn) throws MalformedObjectNameException, IOException {
        String type = "J2EEApplication";
        ObjectName ons = UtilAdmin.getJ2eeMBean(domain, server, type);
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        Iterator<ObjectName> it = onSet.iterator();
        ArrayList<String> nameList = new ArrayList<String>();
        while (it.hasNext()) {
            ObjectName on = it.next();
            String name = on.getKeyProperty("name");
            nameList.add(name);
        }
        return nameList;
    }

    public static String dumpCustom(String domain, String server, MBeanServerConnection conn) throws Exception {
        ObjectName ons;
        Set<ObjectName> onSet;
        String ret = "";
        ObjectName on2 = UtilAdmin.J2EEServer(domain, server);
        String jvmInfos = (String)conn.getAttribute(on2, "jvmInfos");
        ret = ret + jvmInfos;
        ret = ret + "\n";
        on2 = UtilAdmin.getJ2eeMBean(domain, server, "JTAResource", "JTAResource");
        if (conn.isRegistered(on2)) {
            ret = ret + "TM timeout=" + conn.getAttribute(on2, "timeOut");
            ret = ret + "\n";
        }
        if (!(onSet = conn.queryNames(ons = UtilAdmin.getJ2eeMBean(domain, server, "JDBCDataSource"), null)).isEmpty()) {
            for (ObjectName on2 : onSet) {
                String dsInfo = on2.getKeyProperty("name");
                String lockPolicy = null;
                dsInfo = dsInfo + ":lockPolicy=" + lockPolicy;
                dsInfo = dsInfo + ":minPoolSize=" + conn.getAttribute(on2, "jdbcMinConnPool");
                dsInfo = dsInfo + ":maxPoolSize=" + conn.getAttribute(on2, "jdbcMaxConnPool");
                dsInfo = dsInfo + ":maxOpenTime=" + conn.getAttribute(on2, "jdbcMaxOpenTime");
                dsInfo = dsInfo + ":maxWaitTime=" + conn.getAttribute(on2, "jdbcMaxWaitTime");
                dsInfo = dsInfo + ":maxWaiters=" + conn.getAttribute(on2, "jdbcMaxWaiters");
                dsInfo = dsInfo + ":pstmtMax=" + conn.getAttribute(on2, "jdbcPstmtMax");
                dsInfo = dsInfo + "\n";
                ret = ret + dsInfo;
            }
        } else {
            ret = ret + "No DataSources";
            ret = ret + "\n";
        }
        return ret;
    }

    public static ArrayList<ObjectName> listJNDIResources(String domain, String server, MBeanServerConnection conn) throws Exception {
        ArrayList<ObjectName> res = new ArrayList<ObjectName>();
        ObjectName ons = UtilAdmin.getJ2eeMBean(domain, server, "JNDIResource");
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        Iterator<ObjectName> it = onSet.iterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }

    public static String[] getTopics(String domain, String server, MBeanServerConnection conn) throws Exception {
        ObjectName ons = UtilAdmin.getJonasServiceMBean(domain, server, "log");
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        if (onSet.isEmpty()) {
            return null;
        }
        ObjectName on = onSet.iterator().next();
        return (String[])conn.getAttribute(on, "topics");
    }

    public static String getTopicLevel(String domain, String server, MBeanServerConnection conn, String topic) throws Exception {
        ObjectName ons = UtilAdmin.getJonasServiceMBean(domain, server, "log");
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        if (onSet.isEmpty()) {
            return null;
        }
        ObjectName on = onSet.iterator().next();
        String operationName = "getTopicLevel";
        Object[] params = new String[]{topic};
        String[] signature = new String[]{"java.lang.String"};
        return (String)conn.invoke(on, operationName, params, signature);
    }

    public static void setTopicLevel(String domain, String server, MBeanServerConnection conn, String topic, String level) throws Exception {
        ObjectName ons = UtilAdmin.getJonasServiceMBean(domain, server, "log");
        Set<ObjectName> onSet = conn.queryNames(ons, null);
        if (onSet.isEmpty()) {
            return;
        }
        ObjectName on = onSet.iterator().next();
        String operationName = "setTopicLevel";
        Object[] params = new String[]{topic, level};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        conn.invoke(on, operationName, params, signature);
    }
}

