/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArchiveImpl
implements IFileArchive {
    private static final Log logger = LogFactory.getLog(FileArchiveImpl.class);
    private File file = null;
    private URL url = null;

    public FileArchiveImpl() {
    }

    public FileArchiveImpl(File file) {
        this.setFile(file);
    }

    public void setFile(File file) {
        try {
            this.file = file.getCanonicalFile();
        }
        catch (IOException e) {
            logger.debug((Object)"File ''{0}'' cannot be canonicalized, use it as is", new Object[]{file});
            this.file = file;
        }
        this.url = URLUtils.fileToURL((File)this.file);
    }

    public File getFile() {
        return this.file;
    }

    public boolean close() {
        return true;
    }

    public IArchiveMetadata getMetadata() {
        return null;
    }

    public String getName() {
        return this.file.getPath();
    }

    public URL getResource(String resourceName) throws ArchiveException {
        throw new ArchiveException("No resources inside this file");
    }

    public Iterator<URL> getResources() throws ArchiveException {
        throw new ArchiveException("No resources inside this file");
    }

    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        throw new ArchiveException("No resources inside this file");
    }

    public URL getURL() throws ArchiveException {
        return this.url;
    }

    public Iterator<String> getEntries() throws ArchiveException {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

