/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.deployer.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.ow2.jonas.datasource.deployer.binding.ConnectionManagerConfigurationType;
import org.ow2.jonas.datasource.deployer.binding.DatasourceConfigurationType;
import org.ow2.jonas.datasource.deployer.binding.DatasourceType;
import org.ow2.jonas.datasource.deployer.binding.Datasources;
import org.ow2.jonas.datasource.deployer.binding.ObjectFactory;
import org.ow2.jonas.datasource.deployer.reader.DatasourceValidator;
import org.ow2.jonas.datasource.deployer.reader.NamespaceFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DatasourceXmlReader {
    private static final String PSTMT_CACHE_POLICY = "jdbc.pstmtcachepolicy";
    private static final String DEF_PSTMT_CACHE_POLICY = "List";

    public boolean isXmlValid(File xmlFile) {
        try {
            new DatasourceValidator(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Datasources extractDataSources(File xmlFile) throws JAXBException {
        InputSource is;
        XMLReader reader;
        if (!this.isXmlValid(xmlFile)) {
            throw new JAXBException("XML file is not valid.");
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new JAXBException("Unable to create XML Reader", (Throwable)e);
        }
        NamespaceFilter inFilter = new NamespaceFilter("http://jonas.ow2.org/ns/datasource/1.1");
        inFilter.setParent(reader);
        try {
            is = new InputSource(new FileInputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("Unable to analyze file '" + xmlFile + "'.", (Throwable)e);
        }
        SAXSource source = new SAXSource(inFilter, is);
        Datasources theDatasources = (Datasources)unmarshaller.unmarshal((Source)source);
        return theDatasources;
    }

    public DatasourceType initDataSource(DatasourceType dataSource) {
        this.initConnectionManagerConfiguration(dataSource.getConnectionManagerConfiguration());
        this.initDatasourceConfiguration(dataSource.getDatasourceConfiguration());
        return dataSource;
    }

    public Properties getProperties(DatasourceType dataSource) {
        Properties props = new Properties();
        DatasourceConfigurationType dsConfig = dataSource.getDatasourceConfiguration();
        ConnectionManagerConfigurationType cmConfig = dataSource.getConnectionManagerConfiguration();
        props.setProperty("datasource.name", dsConfig.getName());
        props.setProperty("datasource.url", dsConfig.getUrl());
        props.setProperty("datasource.classname", dsConfig.getClassname());
        props.setProperty("datasource.username", dsConfig.getUsername());
        props.setProperty("datasource.password", dsConfig.getPassword());
        props.setProperty("datasource.mapper", dsConfig.getMapper());
        props.setProperty("datasource.description", dsConfig.getDescription());
        props.setProperty("datasource.isolationlevel", dsConfig.getIsolationlevel());
        props.setProperty("jdbc.connchecklevel", String.valueOf(cmConfig.getConnchecklevel()));
        props.setProperty("jdbc.connmaxage", String.valueOf(cmConfig.getConnmaxage()));
        props.setProperty("jdbc.maxopentime", String.valueOf(cmConfig.getMaxopentime()));
        props.setProperty("jdbc.connteststmt", cmConfig.getConnteststmt());
        props.setProperty("jdbc.initconpool", String.valueOf(cmConfig.getInitconpool()));
        props.setProperty("jdbc.minconpool", String.valueOf(cmConfig.getMinconpool()));
        props.setProperty("jdbc.maxconpool", String.valueOf(cmConfig.getMaxconpool()));
        props.setProperty("jdbc.samplingperiod", String.valueOf(cmConfig.getSamplingperiod()));
        props.setProperty("jdbc.maxwaittime", String.valueOf(cmConfig.getMaxwaittime()));
        props.setProperty("jdbc.maxwaiters", String.valueOf(cmConfig.getMaxwaiters()));
        props.setProperty("jdbc.pstmtmax", String.valueOf(cmConfig.getPstmtmax()));
        props.setProperty(PSTMT_CACHE_POLICY, cmConfig.getPstmtcachepolicy());
        return props;
    }

    private void initConnectionManagerConfiguration(ConnectionManagerConfigurationType cmConfig) {
        cmConfig.setConnchecklevel(Integer.valueOf(this.initParam("1", cmConfig.getConnchecklevel())));
        String buffer = this.initParam("1440", cmConfig.getConnmaxage());
        cmConfig.setConnmaxage(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("1440", cmConfig.getMaxopentime());
        cmConfig.setMaxopentime(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("SELECT 1", cmConfig.getConnteststmt());
        cmConfig.setConnteststmt(buffer);
        buffer = this.initParam("12", cmConfig.getPstmtmax());
        cmConfig.setPstmtmax(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam(DEF_PSTMT_CACHE_POLICY, cmConfig.getPstmtcachepolicy());
        cmConfig.setPstmtcachepolicy(buffer);
        buffer = this.initParam("0", cmConfig.getInitconpool());
        cmConfig.setInitconpool(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("0", cmConfig.getMinconpool());
        cmConfig.setMinconpool(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("-1", cmConfig.getMaxconpool());
        cmConfig.setMaxconpool(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("10", cmConfig.getMaxwaittime());
        cmConfig.setMaxwaittime(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("1000", cmConfig.getMaxwaiters());
        cmConfig.setMaxwaiters(BigInteger.valueOf(Long.valueOf(buffer)));
        buffer = this.initParam("30", cmConfig.getSamplingperiod());
        cmConfig.setSamplingperiod(BigInteger.valueOf(Long.valueOf(buffer)));
    }

    private void initDatasourceConfiguration(DatasourceConfigurationType dsConfig) {
        String buffer = this.initParam("datasource.name", dsConfig.getName());
        dsConfig.setName(buffer);
        buffer = this.initParam("no class name", dsConfig.getClassname());
        dsConfig.setClassname(buffer);
        buffer = this.initParam("no url", dsConfig.getUrl());
        dsConfig.setUrl(buffer);
        buffer = this.initParam("no desc", dsConfig.getDescription());
        dsConfig.setDescription(buffer);
        buffer = this.initParam("", dsConfig.getUsername());
        dsConfig.setUsername(buffer);
        buffer = this.initParam("", dsConfig.getPassword());
        dsConfig.setPassword(buffer);
        buffer = this.initParam("", dsConfig.getIsolationlevel());
        dsConfig.setIsolationlevel(buffer);
        buffer = this.initParam("rdb", dsConfig.getMapper());
        dsConfig.setMapper(buffer);
    }

    private String initParam(String paramDefaut, Object paramUser) {
        if (paramUser == null) {
            return paramDefaut;
        }
        return String.valueOf(paramUser);
    }
}

