/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class Property {
    private String m_name;
    private String m_field;
    private String m_value;
    private String m_method;
    private boolean m_mandatory;
    private boolean m_immutable;

    public Property setName(String name) {
        this.m_name = name;
        return this;
    }

    public Property setField(String name) {
        this.m_field = name;
        return this;
    }

    public Property setMethod(String name) {
        this.m_method = name;
        return this;
    }

    public Property setValue(String name) {
        this.m_value = name;
        return this;
    }

    public Property setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        return this;
    }

    public Property setImmutable(boolean immutable) {
        this.m_immutable = immutable;
        return this;
    }

    public Element getElement() {
        this.ensureValidity();
        Element element = new Element("property", "");
        if (this.m_name != null) {
            element.addAttribute(new Attribute("name", this.m_name));
        }
        if (this.m_method != null) {
            element.addAttribute(new Attribute("method", this.m_method));
        }
        if (this.m_value != null) {
            element.addAttribute(new Attribute("value", this.m_value));
        }
        if (this.m_field != null) {
            element.addAttribute(new Attribute("field", this.m_field));
        }
        if (this.m_mandatory) {
            element.addAttribute(new Attribute("mandatory", new Boolean(this.m_mandatory).toString()));
        }
        if (this.m_immutable) {
            element.addAttribute(new Attribute("immutable", new Boolean(this.m_immutable).toString()));
        }
        return element;
    }

    private void ensureValidity() {
        if (this.m_field == null && this.m_method == null) {
            throw new IllegalStateException("A property must have either a field or a method");
        }
        if (this.m_immutable && this.m_value == null) {
            throw new IllegalStateException("A immutable service property must have a value");
        }
    }

    public PropertyDescription getPropertyDescription(ComponentInstance instance) {
        PrimitiveInstanceDescription desc = (PrimitiveInstanceDescription)instance.getInstanceDescription();
        PropertyDescription[] props = desc.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if ((this.m_name == null || !this.m_name.equals(props[i].getName())) && (this.m_field == null || !this.m_field.equals(props[i].getName()))) continue;
            return props[i];
        }
        return null;
    }
}

