/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.config.internal;

import java.util.ArrayList;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="list", scope="config", description="List configurations")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ListConfigurationAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Ffilter;
    @Argument(name="filter", description="LDAP filter used to filter the set of returned Configuration(s).")
    private String filter;
    private boolean __Ftype;
    @Option(name="-t", aliases={"--type"}, description="Reduce the list of Configuration(s) by choosing between factoryand non factory Configurations. (accepted values: factory/conf)")
    private String type;
    private boolean __Fca;
    @Requires
    private ConfigurationAdmin ca;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    String __getfilter() {
        if (!this.__Ffilter) {
            return this.filter;
        }
        return (String)this.__IM.onGet((Object)this, "filter");
    }

    void __setfilter(String string) {
        if (!this.__Ffilter) {
            this.filter = string;
            return;
        }
        this.__IM.onSet((Object)this, "filter", (Object)string);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    ConfigurationAdmin __getca() {
        if (!this.__Fca) {
            return this.ca;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "ca");
    }

    void __setca(ConfigurationAdmin configurationAdmin) {
        if (!this.__Fca) {
            this.ca = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "ca", (Object)configurationAdmin);
    }

    public ListConfigurationAction() {
        this(null);
    }

    private ListConfigurationAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        if (this.__gettype() != null && !"factory".equals(this.__gettype()) && !"conf".equals(this.__gettype())) {
            throw new IllegalArgumentException("Only 'factory' or 'conf' are accepted for the --type option");
        }
        ArrayList<Configuration> bag = new ArrayList<Configuration>();
        Configuration[] configurations = this.__getca().listConfigurations(this.__getfilter());
        if (configurations != null) {
            for (Configuration configuration : configurations) {
                if (this.__gettype() == null) {
                    bag.add(configuration);
                    continue;
                }
                if ("factory".equalsIgnoreCase(this.__gettype()) && configuration.getFactoryPid() != null) {
                    bag.add(configuration);
                    continue;
                }
                if (!"conf".equalsIgnoreCase(this.__gettype()) || configuration.getFactoryPid() != null) continue;
                bag.add(configuration);
            }
        }
        Ansi buffer = Ansi.ansi();
        if (bag.isEmpty()) {
            buffer.fg(Ansi.Color.RED);
            buffer.a("No Configurations available");
            if (this.__getfilter() != null) {
                buffer.a(", using the filter '" + this.__getfilter() + "'");
            }
            if (this.__gettype() != null) {
                buffer.a(", restricting to '" + this.__gettype() + "' type");
            }
            buffer.a(".\n");
            buffer.fg(Ansi.Color.DEFAULT);
        } else {
            buffer.a("Configurations:\n");
            for (Configuration config : bag) {
                buffer.a("  * ");
                buffer.a(Ansi.Attribute.INTENSITY_BOLD);
                buffer.a(config.getPid());
                buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
                if (config.getFactoryPid() != null) {
                    buffer.a(" [factory-pid:");
                    buffer.a(config.getFactoryPid());
                    buffer.a("]");
                }
                buffer.a("\n");
            }
        }
        System.out.println(buffer.toString());
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("ca")) {
                this.__Fca = true;
            }
            if (set.contains("filter")) {
                this.__Ffilter = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

