/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.lib.RdbExtentMappingInfos;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.mapper.rdb.util.ColumnAliasing;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RdbExtentGenInfos {
    public Logger logger;
    public boolean debug = false;

    public RdbExtentGenInfos(Logger logger) {
        this.logger = logger;
        this.debug = logger != null && logger.isLoggable(BasicLevel.DEBUG);
    }

    public Collection getPolymorphicClassExtent(Class classA, String projectName, String mapperName) throws PException {
        return this.getPolymorphicClassExtent(classA, projectName, mapperName, true);
    }

    public Collection getPolymorphicClassExtent(Class classA, String projectName, String mapperName, boolean prefetch) throws PException {
        if (this.debug) {
            this.logger.log(BasicLevel.INFO, (Object)("Calculating extent for class" + classA.getFQName() + " project: " + projectName + ", mapperName: " + mapperName));
        }
        ArrayList primElsOfA = new ArrayList();
        ArrayList primEls = this.getPrimitiveElements(prefetch, classA, projectName, primElsOfA);
        HashMap<Class, RdbExtentMappingInfos> extMappingInfosMap = new HashMap<Class, RdbExtentMappingInfos>();
        ArrayList<RdbExtentMappingInfos> extMappingInfos = new ArrayList<RdbExtentMappingInfos>();
        ArrayList<Class> remClasses = new ArrayList<Class>();
        remClasses.add(classA);
        while (!remClasses.isEmpty()) {
            RdbExtentMappingInfos emi;
            RdbClassMultiMapping classMappingOfX;
            Class classX = (Class)remClasses.remove(0);
            Collection xSubClasses = classX.getSubClasses();
            if (xSubClasses != null) {
                remClasses.addAll(xSubClasses);
            }
            if ((classMappingOfX = (RdbClassMultiMapping)classX.getClassMapping(projectName, mapperName)) == null) {
                throw new PException("Could not find a class mapping for class " + classA.getName());
            }
            if (classX != classA) {
                emi = this.inspectSubclass(classA, classX, classMappingOfX, extMappingInfosMap, extMappingInfos, primElsOfA, primEls, prefetch);
            } else {
                emi = new RdbExtentMappingInfos(classX, classX.getName(), primEls.size());
                extMappingInfos.add(0, emi);
                emi.addFilters = this.requireFilter(classMappingOfX, classX);
                emi.hasUnmappedFields = classMappingOfX.hasUnmappedPrimitiveElements(primElsOfA);
            }
            extMappingInfosMap.put(classX, emi);
            if (classX.isAbstract()) {
                if (!this.debug) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)"Class is abstract, next one");
                continue;
            }
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("  should add filters ? " + (emi.addFilters ? "yes" : "no")));
            }
            if (emi.addFilters) {
                emi.filters.add(classX.getFQName());
            }
            this.projectFields(emi, classMappingOfX, primEls, prefetch);
        }
        Iterator emiIt = extMappingInfos.iterator();
        while (emiIt.hasNext()) {
            RdbExtentMappingInfos emi = (RdbExtentMappingInfos)emiIt.next();
            if (!emi.isEmpty()) continue;
            emiIt.remove();
        }
        return extMappingInfos;
    }

    /*
     * WARNING - void declaration
     */
    private RdbExtentMappingInfos inspectSubclass(Class classA, Class classX, RdbClassMultiMapping classMappingOfX, Map extMappingInfosMap, List extMappingInfos, ArrayList primElsOfA, ArrayList primEls, boolean prefetch) throws PException {
        void var13_13;
        RdbExtentMappingInfos emi;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Inspecting subclass: " + classX.getName()));
        }
        Class[] parent = new Class[1];
        RdbExtentMappingInfos emiParent = this.getParentEMI(classX, extMappingInfosMap, parent);
        ParentClassMapping pcmOfX = classMappingOfX.getParentClassMapping(parent[0].getFQName());
        if (pcmOfX == null) {
            throw new PException("Could not find a parent class mapping for class " + classX.getName() + " to super class" + classA.getName());
        }
        String ruleName = pcmOfX.getRuleName();
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("  inherits mapping from : " + classX.getFQName() + " with rule=" + ruleName));
        }
        if ("to-extended-structures".equalsIgnoreCase(ruleName) || "to-added-structures".equalsIgnoreCase(ruleName) && !prefetch) {
            if (emiParent.hasUnmappedFields) {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Parent class has unmapped fields, create new EMI");
                }
                emi = new RdbExtentMappingInfos(classX, classX.getName(), primEls.size());
                extMappingInfos.add(0, emi);
                emi.addFilters = this.requireFilter(classMappingOfX, classX);
                emi.hasUnmappedFields = classMappingOfX.hasUnmappedPrimitiveElements(primElsOfA);
            } else {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Parent class has all its fields mapped, complement its EMI");
                }
                emi = emiParent;
            }
        } else if ("to-new-structures".equalsIgnoreCase(ruleName) || "to-added-structures".equalsIgnoreCase(ruleName) && prefetch) {
            emi = new RdbExtentMappingInfos(classX, classX.getName(), primEls.size());
            emi.addFilters = this.requireFilter(classMappingOfX, classX);
            extMappingInfos.add(0, emi);
            emi.hasUnmappedFields = classMappingOfX.hasUnmappedPrimitiveElements(primElsOfA);
        } else {
            throw new InternalError("Unexpected inheritance rule: " + ruleName);
        }
        return var13_13;
    }

    private boolean requireFilter(RdbClassMultiMapping classMappingOfX, Class classX) {
        boolean res = classMappingOfX.inheritsStructures();
        if (!res) {
            Mapping mapping = (Mapping)classMappingOfX.getParent();
            String mapperName = mapping.getMapperName();
            String projectName = ((ClassProject)mapping.getParent()).getProjectName();
            Iterator it = classX.getSubClasses().iterator();
            while (it.hasNext() && !res) {
                Class subClassOfX = (Class)it.next();
                RdbClassMultiMapping cm = (RdbClassMultiMapping)subClassOfX.getClassMapping(projectName, mapperName);
                res |= cm.inheritsStructures(cm.getParentClassMapping(classX.getFQName()));
            }
        }
        return res;
    }

    private void projectFields(RdbExtentMappingInfos emi, RdbClassMultiMapping classMappingOfX, ArrayList primEls, boolean prefetch) {
        int pos = 0;
        Iterator it = primEls.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("     find mapping for primitive element " + pe.getName()));
            }
            if (emi.mappingDone(pos) && !emi.mappingNull(pos)) {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"    already done");
                }
            } else {
                RdbPrimitiveElementMapping mappingOfpeInX = (RdbPrimitiveElementMapping)classMappingOfX.getPrimitiveElementMapping(pe.getName(), true);
                String tableName = "";
                if (prefetch && mappingOfpeInX == null) {
                    emi.addProjection(tableName, "NULL", ColumnAliasing.getAliasFromColumn(pe.getName()), ((Class)pe.getParent()).getFQName(), pos);
                } else {
                    RdbJoin join = mappingOfpeInX.getJoinByPrimitiveElement(pe);
                    if (join != null) {
                        if (this.debug) {
                            this.logger.log(BasicLevel.DEBUG, (Object)"     mapped to external table");
                        }
                        tableName = join.getExternalTable().getName();
                        emi.addJoin(join);
                    } else {
                        if (this.debug) {
                            this.logger.log(BasicLevel.DEBUG, (Object)"     mapped to main table");
                        }
                        emi.setMainTable((RdbTable)mappingOfpeInX.getParent());
                        tableName = emi.getMainTable().getName();
                    }
                    emi.addProjection(tableName, mappingOfpeInX.getName(), ColumnAliasing.getAliasFromColumn(pe.getName()), ((Class)pe.getParent()).getFQName(), pos);
                }
            }
            ++pos;
        }
    }

    public ArrayList getAllPrimitiveElementsInGraph(Class classA, String projectName) {
        ArrayList<Class> ancestors = classA.getAllAncestors();
        if (ancestors == Collections.EMPTY_LIST) {
            ancestors = new ArrayList<Class>(1);
        }
        ancestors.add(classA);
        ArrayList<PrimitiveElement> primEls = new ArrayList<PrimitiveElement>();
        Iterator it = ancestors.iterator();
        while (it.hasNext()) {
            Class currentClass = (Class)it.next();
            boolean withSubclasses = false;
            if (currentClass == classA) {
                withSubclasses = true;
            }
            ArrayList primElsOfCurrent = this.getPrimitiveElements(withSubclasses, currentClass, projectName, null);
            Iterator peIt = primElsOfCurrent.iterator();
            while (peIt.hasNext()) {
                PrimitiveElement pe = (PrimitiveElement)peIt.next();
                if (primEls.contains(pe)) continue;
                primEls.add(pe);
            }
        }
        return primEls;
    }

    private ArrayList getPrimitiveElements(boolean withSubtypes, Class classA, String projectName, ArrayList primElsOfA) {
        ArrayList primEls = new ArrayList();
        ArrayList<Class> remClasses = new ArrayList<Class>();
        remClasses.add(classA);
        while (!remClasses.isEmpty()) {
            Object te;
            Class currentClass = (Class)remClasses.remove(0);
            if (withSubtypes) {
                remClasses.addAll(currentClass.getSubClasses());
            }
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Primitive elements are: ");
            }
            Iterator itTE = currentClass.getAllFields().iterator();
            while (itTE.hasNext()) {
                te = itTE.next();
                if (!(te instanceof PrimitiveElement)) continue;
                if (!primEls.contains(te)) {
                    primEls.add(te);
                }
                if (!this.debug) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("   " + ((PrimitiveElement)te).getName()));
            }
            itTE = currentClass.getAllHiddenFields().iterator();
            while (itTE.hasNext()) {
                te = itTE.next();
                if (!(te instanceof PrimitiveElement)) continue;
                if (!primEls.contains(te)) {
                    primEls.add(te);
                }
                if (!this.debug) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("   " + ((PrimitiveElement)te).getName() + " (hidden)"));
            }
            if (primElsOfA == null || currentClass != classA) continue;
            primElsOfA.addAll(primEls);
        }
        return primEls;
    }

    private RdbExtentMappingInfos getParentEMI(Class clazz, Map EMIMap, Class[] parent) {
        this.logger.log(BasicLevel.DEBUG, (Object)"Get parent's EMI");
        if (parent != null) {
            parent[0] = null;
        }
        RdbExtentMappingInfos emiOfParent = null;
        Collection parentsOfX = clazz.getSuperClasses();
        Iterator itP = parentsOfX.iterator();
        while (itP.hasNext()) {
            Class superClass = (Class)itP.next();
            emiOfParent = (RdbExtentMappingInfos)EMIMap.get(superClass);
            if (emiOfParent == null) continue;
            if (parent != null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Return parent=" + superClass.getFQName()));
                parent[0] = superClass;
            }
            return emiOfParent;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Found none");
        return null;
    }
}

