/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.xml2mi.lib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class DTDResolver
implements XMLEntityResolver,
Loggable {
    private ArrayList dtdLocations = null;
    private Logger logger = null;

    public DTDResolver(ArrayList dtdLocations) {
        this.dtdLocations = dtdLocations;
    }

    public DTDResolver(ArrayList dtdLocations, Logger logger) {
        this.dtdLocations = dtdLocations;
        this.logger = logger;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier identifier) throws XNIException, IOException {
        int idx;
        String publicid = identifier.getPublicId();
        String location = null;
        if (publicid == null) {
            location = identifier.getBaseSystemId();
        } else {
            Iterator it = this.dtdLocations.iterator();
            this.logger.log(BasicLevel.DEBUG, (Object)("Looking for the publicId: " + publicid));
            while (it.hasNext()) {
                DTDLocation dtdloc = (DTDLocation)it.next();
                String current = dtdloc.getPublicId();
                this.logger.log(BasicLevel.DEBUG, (Object)("Current public id: " + current));
                if (!current.equals(publicid)) continue;
                location = dtdloc.getLocation();
                break;
            }
        }
        if (location == null) {
            this.logger.log(BasicLevel.WARN, (Object)("No dtd location found for the publicId:" + publicid));
            if (identifier.getBaseSystemId() == null) {
                throw new IOException("Could not resolve publicid: [" + publicid + "]");
            }
            this.logger.log(BasicLevel.WARN, (Object)("Resolved " + publicid + " to with default location " + identifier.getBaseSystemId()));
            return new XMLInputSource(identifier);
        }
        InputStream is = null;
        try {
            is = new FileInputStream(location);
            this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to local file " + location));
        }
        catch (FileNotFoundException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not a local file "));
        }
        if (is == null) {
            URL urldtd = null;
            try {
                urldtd = new URL(location);
                is = urldtd.openStream();
                this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to url " + urldtd));
            }
            catch (IOException e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not an URL "));
            }
        }
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(location);
            if (is != null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Resolved " + publicid + " to resource " + location));
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not availlable in the classpath"));
            }
        }
        if (is == null && (idx = location.indexOf(".jar!")) != -1) {
            try {
                ZipEntry zipentry;
                JarFile jarfile = new JarFile(location.substring(0, idx));
                if (jarfile != null && (zipentry = jarfile.getEntry(location.substring(idx + 5, location.length()))) != null) {
                    is = jarfile.getInputStream(zipentry);
                }
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(location + " is not an jar file"));
            }
        }
        if (is != null) {
            return new XMLInputSource(publicid, identifier.getLiteralSystemId(), identifier.getBaseSystemId(), is, null);
        }
        throw new IOException("Could not resolve publicid: [" + publicid + "] location [" + location + "]");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return null;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
    }
}

