/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.distributed.globallock.lib;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.perseus.concurrency.distributed.globallock.api.DeadLockException;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLock;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockWaiter;
import org.objectweb.perseus.concurrency.distributed.globallock.lib.GlobalLockMessage;
import org.objectweb.perseus.concurrency.distributed.globallock.lib.GlobalLockWaiterImpl;
import org.objectweb.perseus.distribution.api.DistResUser;
import org.objectweb.perseus.distribution.api.DistResUserService;
import org.objectweb.perseus.distribution.api.NotUserException;

public class GlobalLockUser
implements GlobalLock,
DistResUser,
Serializable {
    static final boolean trace = true;
    public transient DistResUserService drus;
    transient Serializable objId;
    byte locallyGranted;
    byte locallyGrantable;
    byte globallyRequested;
    private transient List waiters;
    transient int callBackSN;

    public GlobalLockUser(Serializable objId, DistResUserService drus) {
        this.common_init(objId, drus);
    }

    private void createState() {
        this.locallyGrantable = 0;
        this.locallyGranted = 0;
        this.globallyRequested = 0;
        this.waiters = new LinkedList();
    }

    private void common_init(Serializable objId, DistResUserService drus) {
        this.objId = objId;
        this.drus = drus;
        this.createState();
    }

    public synchronized byte getGrantable() {
        return this.locallyGrantable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalLockWaiter upgrade(byte lck, boolean sync, long timeout) throws DeadLockException, InterruptedException {
        GlobalLockWaiterImpl w;
        GlobalLockUser globalLockUser = this;
        synchronized (globalLockUser) {
            this.trace("LOCAL REQUEST: " + lck);
            if (lck <= this.locallyGrantable) {
                if (lck > this.locallyGranted) {
                    this.locallyGranted = lck;
                }
                this.trace("LOCAL REQUEST GRANTED: " + lck);
                return null;
            }
            w = this.waitForGrantable(lck, timeout);
        }
        if (sync) {
            boolean ok = w.waitLock(timeout);
            if (!ok) {
                this.trace("WAKE UP TIMED OUT (Waiting: " + lck + ")");
                throw new DeadLockException();
            }
            this.trace("WAKE UP (Waiting: " + lck + ")");
            w.signalHandled();
            return null;
        }
        return w;
    }

    public synchronized void downgrade(byte lck) {
        boolean replyCB;
        this.trace("LOCAL DOWNGRADE: " + lck);
        boolean bl = replyCB = this.locallyGrantable < this.locallyGranted && lck <= this.locallyGrantable;
        if (this.locallyGranted > lck) {
            this.locallyGranted = lck;
            if (replyCB) {
                this.trace("CALL BACK RESP: " + lck + " SN=" + this.callBackSN);
                this.sendCoordinator(new GlobalLockMessage(1, lck, 0L, null, this.callBackSN));
                this.callBackSN = -1;
            }
        }
        if (this.globallyRequested > 0) {
            byte l = 0;
            Iterator it = this.waiters.iterator();
            while (it.hasNext()) {
                GlobalLockWaiterImpl waiter = (GlobalLockWaiterImpl)it.next();
                byte wl = waiter.getLockLevel();
                if (wl <= l) continue;
                l = wl;
            }
            if (l == 0) {
                this.trace("CANCEL PENDING REQUEST " + lck);
                this.sendCoordinator(new GlobalLockMessage(2, lck, 0L, null));
            }
            this.globallyRequested = l;
        }
    }

    public synchronized void uncache() {
        this.trace("UNCACHE");
        this.locallyGrantable = 0;
    }

    private synchronized void globalDowngrade(byte lck, Object requester, int SN) {
        this.trace("RCV GLOBAL DOWNGRADE (CB): " + lck + " for " + requester);
        if (this.locallyGrantable > lck) {
            this.locallyGrantable = lck;
        }
        if (lck >= this.locallyGranted) {
            this.trace("SEND GLOBAL DOWNGRADE OK: " + lck);
            this.sendCoordinator(new GlobalLockMessage(1, lck, 0L, requester, SN));
            return;
        }
        this.callBackSN = SN;
        this.trace("SEND GLOBAL DOWNGRADE NOT OK: " + lck);
    }

    private synchronized void globalUpgrade(byte lck) {
        GlobalLockWaiterImpl prevWaiter = null;
        this.trace("RCV GLOBAL UPGRADE: " + lck);
        if (this.locallyGrantable < lck) {
            this.locallyGrantable = lck;
        }
        if (this.globallyRequested == lck) {
            this.globallyRequested = 0;
        }
        this.trace("WAKEUP waiters: " + lck);
        Iterator it = this.waiters.iterator();
        while (it.hasNext()) {
            GlobalLockWaiterImpl waiter = (GlobalLockWaiterImpl)it.next();
            this.trace("SIGNAL LOCK TO WAITER: " + waiter);
            byte wLock = waiter.getLockLevel();
            if (!waiter.signalLock(lck, prevWaiter)) break;
            if (this.locallyGranted < wLock) {
                this.locallyGranted = wLock;
            }
            this.trace("SIGNAL OK: " + waiter);
            prevWaiter = waiter;
            it.remove();
        }
    }

    private GlobalLockWaiterImpl waitForGrantable(byte lck, long timeout) {
        if (lck > this.globallyRequested) {
            this.globallyRequested = lck;
            this.trace("SEND GLOBAL REQUEST: " + lck);
            this.sendCoordinator(new GlobalLockMessage(0, lck, timeout, this.drus.getNodeId()));
        } else {
            this.trace("ALREADY AE PENDING REQUEST : " + this.globallyRequested);
        }
        this.trace(" BLOCKED (Waiting: " + lck + " for " + timeout + " millis)");
        GlobalLockWaiterImpl w = new GlobalLockWaiterImpl(lck);
        this.trace(" ADD WAITER: " + w);
        this.waiters.add(w);
        return w;
    }

    protected void sendCoordinator(Serializable message) {
        try {
            Serializable resId = this.objId;
            this.drus.sendToCoordinator((Object)resId, message);
        }
        catch (NotUserException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receive(Object objId, Serializable message) {
        if (!(message instanceof GlobalLockMessage)) throw new InternalError();
        GlobalLockMessage req = (GlobalLockMessage)message;
        if (req.type == 2) {
            this.globalUpgrade(req.lck);
            return;
        } else {
            if (req.type != 3) throw new InternalError();
            this.globalDowngrade(req.lck, req.requester, req.serialNumber);
        }
    }

    public synchronized Serializable getState(Object resId) {
        this.trace("COORD SEEMS TO BE DOWN: return state");
        return this;
    }

    public synchronized String toString() {
        Serializable nodeId = this.drus == null ? null : this.drus.getNodeId();
        return "USER OF " + this.objId + " (" + nodeId + ")[" + this.locallyGrantable + this.locallyGranted + this.globallyRequested + "] T=" + Thread.currentThread().hashCode() + " ";
    }

    protected void trace(String s) {
        System.out.println(this + " " + s);
    }

    void finilaze() {
    }
}

