/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.jms.JmsManager;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JMessageDrivenBean;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JMdbFactory
extends JFactory
implements ServerSessionPool {
    private JmsManager jms = null;
    private ConnectionConsumer cc = null;
    private List sspool = new ArrayList();
    private int instanceCount = 0;
    private int minPoolSize = 0;
    private int maxCacheSize = 0;
    private XATopicConnection tconn = null;
    private XAQueueConnection qconn = null;

    public JMdbFactory(MessageDrivenDesc dd, JContainer cont) {
        super((BeanDesc)dd, cont);
        this.txbeanmanaged = dd.isBeanManagedTransaction();
        this.jms = cont.getJmsManager();
        if (this.jms == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot deploy a message driven bean without the JMS Service");
            throw new EJBException("JMS Service must be run");
        }
        String selector = dd.getSelector();
        String dest = dd.getDestinationJndiName();
        int maxMessages = 1;
        if (dest == null) {
            throw new EJBException("The destination JNDI name is null in bean " + dd.getEjbName());
        }
        try {
            if (dd.isTopicDestination()) {
                XATopicConnectionFactory tcf = this.jms.getXATopicConnectionFactory();
                this.tconn = tcf.createXATopicConnection();
                Topic t = this.jms.getTopic(dest);
                if (dd.isSubscriptionDurable()) {
                    if (TraceEjb.isDebugJms()) {
                        TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)("createDurableConnectionConsumer for " + this.ejbname));
                    }
                    this.cc = this.tconn.createDurableConnectionConsumer(t, this.ejbname, selector, (ServerSessionPool)this, maxMessages);
                } else {
                    if (TraceEjb.isDebugJms()) {
                        TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)("createConnectionConsumer for " + dest));
                    }
                    this.cc = this.tconn.createConnectionConsumer(t, selector, (ServerSessionPool)this, maxMessages);
                }
                this.tconn.start();
            } else {
                XAQueueConnectionFactory qcf = this.jms.getXAQueueConnectionFactory();
                this.qconn = qcf.createXAQueueConnection();
                Queue q = this.jms.getQueue(dest);
                if (TraceEjb.isDebugJms()) {
                    TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)("createConnectionConsumer for " + dest));
                }
                this.cc = this.qconn.createConnectionConsumer(q, selector, (ServerSessionPool)this, maxMessages);
                this.qconn.start();
            }
        }
        catch (Exception e) {
            throw new EJBException("Cannot create connection consumer in bean " + dd.getEjbName() + " :", e);
        }
        this.minPoolSize = dd.getPoolMin();
        this.maxCacheSize = dd.getCacheMax();
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(" maxCacheSize = " + this.maxCacheSize + " minPoolSize = " + this.minPoolSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInstancePool() {
        if (this.minPoolSize != 0) {
            TraceEjb.mdb.log(BasicLevel.INFO, (Object)("pre-allocate a set of " + this.minPoolSize + " message driven bean  instances"));
            List list = this.sspool;
            synchronized (list) {
                for (int i = 0; i < this.minPoolSize; ++i) {
                    JMessageDrivenBean ss = null;
                    try {
                        ss = this.createNewInstance();
                        this.sspool.add(ss);
                        continue;
                    }
                    catch (Exception e) {
                        TraceEjb.mdb.log(BasicLevel.ERROR, (Object)"cannot init pool of instances ");
                        throw new EJBException("cannot init pool of instances ", e);
                    }
                }
            }
        }
    }

    public int getPoolSize() {
        return this.sspool.size();
    }

    public void stop() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.cc.close();
            if (this.tconn != null) {
                this.tconn.close();
            }
            if (this.qconn != null) {
                this.qconn.close();
            }
        }
        catch (JMSException e) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"unregister: Cannot close Connection Consumer");
        }
        this.stopContainer();
    }

    public void syncDirty(boolean notused) {
    }

    public JHome getHome() {
        return null;
    }

    public JLocalHome getLocalHome() {
        return null;
    }

    public ServerSession getServerSession() throws JMSException {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.getNewInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServerSession(ServerSession ss) {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        List list = this.sspool;
        synchronized (list) {
            this.sspool.add(ss);
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)"notifyAll ");
            }
            this.sspool.notifyAll();
        }
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)("nb instances " + this.getCacheSize()));
        }
    }

    public TimerService getTimerService() {
        if (this.myTimerService == null) {
            this.myTimerService = new JTimerService(this);
        }
        return this.myTimerService;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getCacheSize() {
        return this.instanceCount;
    }

    public int getTransactionAttribute() {
        return ((MessageDrivenDesc)this.dd).getTxAttribute();
    }

    public void checkTransaction(RequestCtx rctx) {
        if (rctx.txAttr == 2) {
            try {
                if (this.tm.getTransaction() != null) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Transaction already opened by this thread.");
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Transaction status = " + this.tm.getStatus()));
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Transaction = " + this.tm.getTransaction()));
                    Thread.dumpStack();
                    return;
                }
                this.tm.begin();
                rctx.mustCommit = true;
                rctx.currTx = this.tm.getTransaction();
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Transaction started: " + rctx.currTx));
                }
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot start tx", (Throwable)e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceCache() {
        int poolsz = this.minPoolSize;
        List list = this.sspool;
        synchronized (list) {
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("try to reduce " + this.sspool.size() + " to " + poolsz));
            }
            while (this.sspool.size() > poolsz) {
                ListIterator i = this.sspool.listIterator();
                if (!i.hasNext()) continue;
                i.next();
                i.remove();
                --this.instanceCount;
            }
        }
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("cacheSize= " + this.getCacheSize()));
        }
    }

    public void notifyTimeout(Timer timer) {
        if (this.stopped) {
            TraceEjb.mdb.log(BasicLevel.WARN, (Object)"Container stopped");
            return;
        }
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        JMessageDrivenBean jmdb = null;
        jmdb = this.getNewInstance(false);
        jmdb.deliverTimeout(timer);
        this.releaseServerSession(jmdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMessageDrivenBean getNewInstance(boolean canwait) {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        JMessageDrivenBean ss = null;
        List list = this.sspool;
        synchronized (list) {
            if (!this.sspool.isEmpty()) {
                try {
                    ss = (JMessageDrivenBean)this.sspool.remove(0);
                    return ss;
                }
                catch (IndexOutOfBoundsException ex) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("exception:" + ex));
                    throw new EJBException("Cannot get an instance from the pool", (Exception)ex);
                }
            }
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"pool is empty");
            }
            if (this.maxCacheSize == 0 || this.instanceCount < this.maxCacheSize || !canwait) {
                try {
                    ss = this.createNewInstance();
                }
                catch (Exception e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("exception:" + e));
                    throw new EJBException("Cannot create a new instance", e);
                }
            } else {
                while (this.sspool.isEmpty()) {
                    if (TraceEjb.isDebugSwapper()) {
                        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)"sspool.isEmpty() = true --> wait()");
                    }
                    try {
                        this.sspool.wait();
                        if (!TraceEjb.isDebugSwapper()) continue;
                        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)"sspool notified");
                    }
                    catch (InterruptedException e) {
                        if (!TraceEjb.isDebugSwapper()) continue;
                        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)"sspool waiting interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new EJBException("synchronization pb", e);
                    }
                }
                try {
                    ListIterator i = this.sspool.listIterator();
                    if (i.hasNext()) {
                        ss = (JMessageDrivenBean)i.next();
                        i.remove();
                    }
                    return ss;
                }
                catch (IndexOutOfBoundsException ex) {
                    // empty catch block
                }
            }
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("nb instances " + this.getCacheSize()));
            }
            return ss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMessageDrivenBean createNewInstance() throws Exception {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        Object sess = null;
        JMessageDrivenBean ss = null;
        MessageDrivenDesc mdd = (MessageDrivenDesc)this.dd;
        if (this.tconn != null) {
            sess = mdd.isRequired() ? this.tconn.createXATopicSession() : this.tconn.createTopicSession(false, mdd.getAcknowledgeMode());
        } else if (this.qconn != null) {
            sess = mdd.isRequired() ? this.qconn.createXAQueueSession() : this.qconn.createQueueSession(false, mdd.getAcknowledgeMode());
        } else {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)"connection not initialized");
            throw new Exception("JMS connection not initialized");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.myClassLoader());
        MessageDrivenBean mdb = null;
        try {
            mdb = (MessageDrivenBean)this.beanclass.newInstance();
        }
        catch (Exception e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"failed to create instance:", (Throwable)e);
            this.resetToOldClassLoader(old);
            throw new EJBException("Container failed to create instance of Message Driven Bean", e);
        }
        ss = new JMessageDrivenBean(this, (Session)sess, mdb, this.wm);
        try {
            sess.setMessageListener((MessageListener)ss);
        }
        catch (JMSException je) {
            this.resetToOldClassLoader(old);
            throw je;
        }
        Context ctxsave = this.setComponentContext();
        mdb.setMessageDrivenContext((MessageDrivenContext)ss);
        try {
            try {
                Method m = this.beanclass.getMethod("ejbCreate", null);
                boolean bm = m.isAccessible();
                if (!bm) {
                    m.setAccessible(true);
                }
                m.invoke((Object)mdb, (Object[])null);
                m.setAccessible(bm);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot call ejbCreate on message driven bean instance ", (Throwable)e);
                throw new EJBException(" Container fails to call ejbCreate on message driven bean instance", e);
            }
            Object var10_12 = null;
            this.resetToOldClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.resetToOldClassLoader(old);
            this.resetComponentContext(ctxsave);
            throw throwable;
        }
        this.resetComponentContext(ctxsave);
        List list = this.sspool;
        synchronized (list) {
            ++this.instanceCount;
        }
        return ss;
    }

    private void resetToOldClassLoader(ClassLoader old) {
        if (old != null) {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void storeInstances(Transaction tx) {
    }
}

