/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain;

import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

public class DeployAction {
    private int state = -1;
    public static final int FAILED = -1;
    public static final int SUCCESS = 0;
    public static final int UPLOADING = 1;
    public static final int DEPLOYING = 2;
    public static final int UNDEPLOYING = 3;
    private String errorMessage;
    private ServerProxy proxy;
    private String filename;
    private int action;
    public static final int DEPLOY = 1;
    public static final int UNDEPLOY = 2;
    public static final int UPLOAD = 3;
    public static final int UPLOADDEPLOY = 4;
    public static final int START = 5;
    public static final int STOP = 6;

    public DeployAction(ServerProxy proxy, String filename, int action) {
        this.proxy = proxy;
        this.filename = filename;
        this.action = action;
        switch (action) {
            case 1: {
                this.state = 2;
                break;
            }
            case 2: {
                this.state = 3;
                break;
            }
            case 3: 
            case 4: {
                this.state = 1;
            }
        }
    }

    public void setOK() {
        this.state = 0;
    }

    public void setDeploying() {
        this.state = 2;
    }

    public void setError(String mess) {
        this.state = -1;
        this.errorMessage = mess;
    }

    public int getState() {
        return this.state;
    }

    public String getStateAsString() {
        switch (this.state) {
            case -1: {
                return "FAILED :";
            }
            case 0: {
                return "SUCCESS";
            }
            case 2: {
                return "IN PROGRESS : DEPLOY";
            }
            case 3: {
                return "IN PROGRESS : UNDEPLOY";
            }
            case 1: {
                return "IN PROGRESS : UPLOAD";
            }
        }
        return "error";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getAction() {
        return this.action;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getServerName() {
        return this.proxy.getName();
    }
}

