/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.addon.deploy.api.config.IAddonConfig;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployerLog;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.impl.config.AddonConfigImpl;
import org.ow2.jonas.addon.deploy.impl.deployer.AddonMetaData;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfDeployerImpl {
    private static Log logger = LogFactory.getLog(ConfDeployerImpl.class);
    public final String SERVICE_REGISTRATION_ADDON_PROPERTY = "addon";
    private BundleContext bundleContext;
    private List<ServiceRegistration> serviceRegistrations;

    public ConfDeployerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
    }

    public void deploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData) {
        String addonConfigurationPath = null;
        String addonDirectory = null;
        try {
            addonDirectory = unpackedDeployable.getArchive().getURL().getPath();
            addonConfigurationPath = addonDirectory + "conf";
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cant get URL archive", new Object[]{e});
        }
        String addonName = addonMetaData.getName();
        String JOnASAddonDirectoryPath = AddonUtil.getAddonDirectoryPath(addonName);
        File JOnASAddonDirectory = new File(JOnASAddonDirectoryPath);
        if (!JOnASAddonDirectory.exists()) {
            JOnASAddonDirectory.mkdirs();
        }
        File addonMetaDataFile = addonMetaData.getAddonMetaDataFile();
        try {
            FileUtils.copyFile((String)addonMetaDataFile.getAbsolutePath(), (String)(JOnASAddonDirectory + File.separator + addonMetaDataFile.getName()));
        }
        catch (FileUtilsException e) {
            logger.error((Object)("Cannot copy file " + addonMetaDataFile.getAbsolutePath() + "."), new Object[]{e});
        }
        AddonUtil.copyFiles(addonConfigurationPath, JOnASAddonDirectoryPath);
        try {
            this.register(JOnASAddonDirectoryPath, addonName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot register a new IAddonConfig component with " + JOnASAddonDirectoryPath + " directory"), new Object[]{e});
        }
    }

    public void undeploy(IArchive unpackedArchive, AddonMetaData addonMetaData, IAddonDeployerLog<IAddonLogEntry> addonDeployerLog) {
        String unpackedDeployablePath = null;
        try {
            unpackedDeployablePath = unpackedArchive.getURL().getPath();
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cannot get the URL of the Archive to undeploy", new Object[]{e});
        }
        String addonName = addonMetaData.getName();
        HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
        addonsToUndeploy.put(addonName, unpackedDeployablePath);
        this.unregister(addonName);
        this.retrieveJOnASConfiguration(addonDeployerLog, addonsToUndeploy, false);
    }

    public void retrieveJOnASConfiguration(IAddonDeployerLog<IAddonLogEntry> addonDeployerLog, Map<String, String> addonsToUndeploy, boolean isJOnASStarting) {
        for (String addonName : addonsToUndeploy.keySet()) {
            String JOnASAddonDirectoryPath = AddonUtil.getAddonDirectoryPath(addonName);
            this.deleteFile(JOnASAddonDirectoryPath);
        }
        if (isJOnASStarting) {
            Vector logEntries = addonDeployerLog.getEntries();
            for (IAddonLogEntry logEntry : logEntries) {
                String addonName = logEntry.getName();
                if (addonsToUndeploy.containsKey(addonName)) continue;
                String addonConfDirectory = AddonUtil.getAddonDirectoryPath(addonName);
                try {
                    this.register(addonConfDirectory, addonName);
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot register a new IAddonConfig component with " + addonConfDirectory + " directory"), new Object[]{e});
                }
            }
        }
    }

    public boolean deleteFile(String directoryPath) {
        File file = new File(directoryPath);
        if (file.exists()) {
            return FileUtils.delete((String)directoryPath);
        }
        return false;
    }

    private void register(String configurationDirectory, String addonName) throws Exception {
        AddonConfigImpl addonConfig = new AddonConfigImpl(configurationDirectory);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("addon", addonName);
        this.serviceRegistrations.add(this.bundleContext.registerService(IAddonConfig.class.getName(), (Object)addonConfig, dictionary));
    }

    private void unregister(String addonName) {
        ServiceRegistration serviceRegistration = AddonUtil.getServiceRegistration(this.serviceRegistrations, "addon", addonName);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            this.serviceRegistrations.remove(serviceRegistration);
        }
    }
}

