/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.carol.jndi.spi.URLInitialContextFactory;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsInitialContextFactory<T extends Context>
implements InitialContextFactory {
    private static HashMap<String, Context> contexts = new HashMap();

    protected String getReferencingFactory() {
        return URLInitialContextFactory.class.getName();
    }

    protected abstract Class<T> getWrapperClass();

    protected Class<T> getWrapperClass(String host) {
        return this.getWrapperClass();
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Hashtable<Object, Object> env = new Hashtable<Object, Object>(environment);
        Context ctx = null;
        String key = this.getKey(env);
        if (key != null) {
            ctx = contexts.get(key);
        }
        if (ctx != null) {
            return ctx;
        }
        this.init();
        env.put("java.naming.factory.initial", this.getReferencingFactory());
        Class<T> clazz = this.getWrapperClass(key);
        Constructor<T> ctr = null;
        try {
            ctr = clazz.getConstructor(this.getClassConstructor());
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot find the constructor with Context class as argument in class '" + clazz.getName() + "' : " + e.getMessage(), e);
        }
        this.addExtraConfInEnvironment(env);
        try {
            ctx = (Context)ctr.newInstance(this.getClassArgs(env));
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot build an instance of the class '" + clazz.getName() + "' : " + e.getMessage(), e);
        }
        if (key != null) {
            contexts.put(key, ctx);
        }
        return ctx;
    }

    protected String getKey(Hashtable<?, ?> environment) {
        String key = null;
        if (environment != null) {
            key = (String)environment.get("java.naming.provider.url");
        }
        return key;
    }

    protected Object[] getClassArgs(Hashtable<?, ?> environment) throws NamingException {
        return new Object[]{new InitialContext(environment)};
    }

    protected Class<?>[] getClassConstructor() {
        return new Class[]{Context.class};
    }

    protected void addExtraConfInEnvironment(Hashtable<Object, Object> environment) {
    }

    protected void init() throws NamingException {
    }
}

