/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.ipojo.instances.internal;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.ow2.jonas.ipojo.interceptor.ComponentInstanceState;
import org.ow2.jonas.ipojo.interceptor.IInstanceProvider;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.DateTimeType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.IpojoInstanceType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.IpojoInstances;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.PropertyType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.ProvideType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.ProvidesType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.RequirementType;
import org.ow2.jonas.report.extensions.ipojo.instances.generated.RequirementsType;
import org.ow2.jonas.service.report.util.Utility;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class IpojoInstancesReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    public static final Log logger = LogFactory.getLog(IpojoInstancesReportExtension.class);
    public static final String XSD_PATH = "xsd/ipojo-instances-report.xsd";
    public static final String REQUIRED_HANDLER_NAME = "org.apache.felix.ipojo:requires";
    public static final String PROVIDES_HANDLER_NAME = "org.apache.felix.ipojo:provides";
    public static final String EOL = "\n";
    private boolean __FinstanceProviders;
    private List<IInstanceProvider> instanceProviders;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider;
    private boolean __MunbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider;

    List __getinstanceProviders() {
        if (!this.__FinstanceProviders) {
            return this.instanceProviders;
        }
        return (List)this.__IM.onGet((Object)this, "instanceProviders");
    }

    void __setinstanceProviders(List list) {
        if (!this.__FinstanceProviders) {
            this.instanceProviders = list;
            return;
        }
        this.__IM.onSet((Object)this, "instanceProviders", (Object)list);
    }

    public IpojoInstancesReportExtension() {
        this(null);
    }

    private IpojoInstancesReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setinstanceProviders(new ArrayList());
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        IpojoInstances ipojoInstances = new IpojoInstances();
        List<IpojoInstanceType> ipojoServiceTypeList = ipojoInstances.getIpojoInstance();
        for (IInstanceProvider instanceProvider : this.__getinstanceProviders()) {
            String objectName;
            Element[] elements;
            String source;
            Long upTimeLong;
            IpojoInstanceType ipojoServiceType = new IpojoInstanceType();
            ipojoServiceType.setName(instanceProvider.getName());
            ipojoServiceType.setState(instanceProvider.getStateComponent().toString());
            Date date = instanceProvider.getStartTime();
            if (date != null) {
                DateTimeType startTime = new DateTimeType();
                startTime.setTimestamp(BigInteger.valueOf(date.getTime()));
                startTime.setDateTime(Utility.date2XMLGregorianCalendar((Date)date));
                ipojoServiceType.setStartTime(startTime);
            }
            if ((upTimeLong = instanceProvider.getUpTime()) != null && (date = new Date(upTimeLong)) != null) {
                DateTimeType upTime = new DateTimeType();
                upTime.setDateTime(Utility.date2XMLGregorianCalendar((Date)date));
                upTime.setTimestamp(BigInteger.valueOf(date.getTime()));
                ipojoServiceType.setUpTime(upTime);
            }
            if ((date = instanceProvider.getShutdownTime()) != null) {
                DateTimeType shutdownTime = new DateTimeType();
                shutdownTime.setDateTime(Utility.date2XMLGregorianCalendar((Date)date));
                shutdownTime.setTimestamp(BigInteger.valueOf(date.getTime()));
                ipojoServiceType.setShutdownTime(shutdownTime);
            }
            if ((source = instanceProvider.getSource()) != null) {
                ipojoServiceType.setSource(source);
            }
            ProvidesType providesType = new ProvidesType();
            List<ProvideType> provides = providesType.getProvide();
            RequirementsType requirementsType = new RequirementsType();
            List<RequirementType> requirements = requirementsType.getRequirement();
            boolean isInstanceValid = ComponentInstanceState.VALID.toString().equals(ipojoServiceType.getState());
            InstanceDescription instanceDescription = instanceProvider.getInstanceDescription();
            for (HandlerDescription handlerDescription : instanceDescription.getHandlers()) {
                String value;
                String name;
                Attribute[] attributes;
                Element[] elements2;
                Element element;
                String handlerName = handlerDescription.getHandlerName();
                if (!isInstanceValid && REQUIRED_HANDLER_NAME.equals(handlerName)) {
                    RequirementType requirement = new RequirementType();
                    element = handlerDescription.getHandlerInfo();
                    if (element != null && (elements2 = element.getElements("requires")) != null) {
                        Element requireElt = elements2[0];
                        for (Attribute attribute : attributes = requireElt.getAttributes()) {
                            name = attribute.getName();
                            value = attribute.getValue();
                            if ("id".equals(name)) {
                                requirement.setId(value);
                                continue;
                            }
                            if ("".equals(name)) {
                                requirement.setAggregate(value);
                                continue;
                            }
                            if ("instance.name".equals(name)) {
                                requirement.setInstanceName(value);
                                continue;
                            }
                            if ("optional".equals(name)) {
                                requirement.setOptional(value);
                                continue;
                            }
                            if ("specification".equals(name)) {
                                requirement.setSpecification(value);
                                continue;
                            }
                            if ("optional".equals(name)) {
                                requirement.setOptional(value);
                                continue;
                            }
                            if ("state".equals(name)) {
                                requirement.setState(value);
                                continue;
                            }
                            if ("nullable".equals(name)) {
                                requirement.setNullable(value);
                                continue;
                            }
                            if ("binding-policy".equals(name)) {
                                requirement.setBindingPolicy(value);
                                continue;
                            }
                            if (!"proxy".equals(name)) continue;
                            requirement.setProxy(value);
                        }
                    }
                    requirements.add(requirement);
                    continue;
                }
                if (!isInstanceValid || !PROVIDES_HANDLER_NAME.equals(handlerName)) continue;
                ProvideType provide = new ProvideType();
                element = handlerDescription.getHandlerInfo();
                if (element != null && (elements2 = element.getElements("provides")) != null) {
                    Element provideElt = elements2[0];
                    for (Attribute attribute : attributes = provideElt.getAttributes()) {
                        name = attribute.getName();
                        value = attribute.getValue();
                        if ("specifications".equals(name)) {
                            provide.setSpecifications(value);
                            continue;
                        }
                        if (!"state".equals(name)) continue;
                        provide.setState(value);
                    }
                    List<PropertyType> properties = provide.getProperty();
                    for (Element child : provideElt.getElements()) {
                        if (!"property".equals(child.getName())) continue;
                        PropertyType property = new PropertyType();
                        property.setName(child.getAttribute("name"));
                        property.setValue(child.getAttribute("value"));
                        properties.add(property);
                    }
                }
                provides.add(provide);
            }
            ipojoServiceType.setBundleId(instanceDescription.getBundleId());
            Element element = instanceDescription.getDescription();
            if (element != null && (elements = element.getElements("object")) != null && elements.length > 0 && (objectName = elements[0].getAttribute("name")) != null) {
                ipojoServiceType.setObjectName(objectName);
            }
            if (isInstanceValid) {
                ipojoServiceType.setProvides(providesType);
            } else {
                ipojoServiceType.setRequirements(requirementsType);
                ipojoServiceType.setArch(EOL + instanceDescription.getDescription().toString() + EOL);
            }
            ipojoServiceTypeList.add(ipojoServiceType);
        }
        return ipojoInstances;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/ipojo-instances-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return IpojoInstances.class;
    }

    public void bindServiceProvider(IInstanceProvider iInstanceProvider) {
        if (!this.__MbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider) {
            this.__M_bindServiceProvider(iInstanceProvider);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", new Object[]{iInstanceProvider});
            this.__M_bindServiceProvider(iInstanceProvider);
            this.__IM.onExit((Object)this, "bindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", throwable);
            throw throwable;
        }
    }

    private void __M_bindServiceProvider(IInstanceProvider instanceProvider) {
        this.__getinstanceProviders().add(instanceProvider);
    }

    public void unbindServiceProvider(IInstanceProvider iInstanceProvider) {
        if (!this.__MunbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider) {
            this.__M_unbindServiceProvider(iInstanceProvider);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", new Object[]{iInstanceProvider});
            this.__M_unbindServiceProvider(iInstanceProvider);
            this.__IM.onExit((Object)this, "unbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider", throwable);
            throw throwable;
        }
    }

    private void __M_unbindServiceProvider(IInstanceProvider instanceProvider) {
        this.__getinstanceProviders().remove(instanceProvider);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("instanceProviders")) {
            this.__FinstanceProviders = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("bindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider")) {
                this.__MbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider = true;
            }
            if (set.contains("unbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider")) {
                this.__MunbindServiceProvider$org_ow2_jonas_ipojo_interceptor_IInstanceProvider = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

