/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptionContext;
import org.ow2.jonas.jndi.interceptors.impl.AbsContextInterceptor;
import org.ow2.jonas.jndi.interceptors.impl.datasource.DatasourceWrapper;

public class DataSourceLeakDetectorContextInterceptor
extends AbsContextInterceptor
implements ContextInterceptor {
    private TransactionManager transactionManager;
    private boolean forceClose = true;

    public Object intercept(InterceptionContext context) throws Exception {
        Object obj = context.proceed();
        Method method = context.getMethod();
        if (this.filterOnMethodName(method) && this.filterOnJndiName(context.getParameters()[0].toString()) && DataSource.class.isAssignableFrom(obj.getClass())) {
            DataSource ds = (DataSource)obj;
            DatasourceWrapper detector = new DatasourceWrapper(ds, this.getResourceCheckerManager(), this.transactionManager);
            detector.setForceClose(this.forceClose);
            return detector;
        }
        return obj;
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    public void setForceClose(boolean forceClose) {
        this.forceClose = forceClose;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

