/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.jndi.interceptors.impl.datasource.ConnectionProxy;
import org.ow2.jonas.jndi.interceptors.impl.datasource.NonTransactionalConnectionProxy;
import org.ow2.jonas.jndi.interceptors.impl.datasource.TransactionalConnectionProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceWrapper
implements DataSource {
    private static Log logger = LogFactory.getLog(DatasourceWrapper.class);
    private boolean forceClose = true;
    private DataSource delegate = null;
    private IResourceCheckerManager manager;
    private TransactionManager transactionManager;

    public DatasourceWrapper(DataSource delegate, IResourceCheckerManager manager, TransactionManager transactionManager) {
        this.delegate = delegate;
        this.manager = manager;
        this.transactionManager = transactionManager;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.wrapConnection(this.delegate.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.wrapConnection(this.delegate.getConnection(username, password));
    }

    protected synchronized Connection wrapConnection(Connection connection) {
        ConnectionProxy connectionProxy = null;
        connectionProxy = this.isTransactional() ? new TransactionalConnectionProxy(connection, this.getTransaction()) : new NonTransactionalConnectionProxy(connection, this.manager);
        connectionProxy.setForceClose(this.forceClose);
        connectionProxy.registerConnection();
        return (Connection)Proxy.newProxyInstance(this.delegate.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)connectionProxy);
    }

    private boolean isTransactional() {
        return this.getTransaction() != null;
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get current Transaction", e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public String getMapperName() {
        Method getMapperNameMethod = null;
        try {
            getMapperNameMethod = this.delegate.getClass().getMethod("getMapperName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (String)getMapperNameMethod.invoke((Object)this.delegate, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public void setForceClose(boolean forceClose) {
        this.forceClose = forceClose;
    }

    public boolean equals(Object other) {
        if (this == this.delegate) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DatasourceWrapper otherDatasource = (DatasourceWrapper)other;
        return this.delegate.equals(otherDatasource.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }
}

