/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentHelper;
import org.ow2.util.plan.bindings.deploymentplan.maven2.Maven2Deployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.fetcher.impl.AbsResourceFetcherImpl;
import org.ow2.util.plan.fetcher.impl.maven2.Maven2Utils;
import org.ow2.util.url.URLUtils;

public class Maven2ResourceFetcher
extends AbsResourceFetcherImpl
implements IResourceFetcher {
    private static final Log logger = LogFactory.getLog(Maven2ResourceFetcher.class);
    private File localFile = null;
    private URL foundURL = null;
    private long lastModified;

    public RepositoryKind getSupportedRepositoryType() {
        return RepositoryKind.MAVEN_2;
    }

    public File getResource() throws ResourceFetcherNotResolvedException {
        if (this.localFile == null) {
            throw new ResourceFetcherNotResolvedException();
        }
        return this.localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanged() throws FetcherException {
        URLConnection connection = null;
        try {
            connection = this.foundURL.openConnection();
            Maven2Utils.addAuthenticationOnURL(connection);
            connection.setReadTimeout(3000);
            if (connection.getLastModified() != this.lastModified) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Cannot retrieve the last modification date for the URL {0} : {1}", new Object[]{this.foundURL, e.getMessage()});
        }
        finally {
            try {
                if (connection.getInputStream() != null) {
                    connection.getInputStream().close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public void resolve() throws FetcherException {
        if (this.deployment == null) {
            throw new FetcherException((Throwable)new InvalidDeploymentException("Null deployment"));
        }
        if (!(this.deployment instanceof Maven2Deployment)) {
            throw new FetcherException((Throwable)new InvalidDeploymentException("Bad deployment type: " + this.deployment.getClass().getName()));
        }
        Maven2Deployment maven2Deployment = (Maven2Deployment)this.deployment;
        logger.debug((Object)"Trying to resolve resource {0}", new Object[]{maven2Deployment.toString()});
        String groupId = maven2Deployment.getGroupId();
        String artifactId = maven2Deployment.getArtifactId();
        String version = maven2Deployment.getVersion();
        String type = maven2Deployment.getType();
        String classifier = maven2Deployment.getClassifier();
        if (groupId == null || artifactId == null || version == null) {
            throw new FetcherException((Throwable)new InvalidDeploymentException("Incomplete maven description: " + maven2Deployment));
        }
        String repositoryRef = null;
        try {
            repositoryRef = DeploymentHelper.getRepositoryRef((Deployment)maven2Deployment);
        }
        catch (InvalidDeploymentException e) {
            logger.error((Object)e.getMessage(), new Object[0]);
        }
        if (type == null) {
            type = "jar";
        }
        this.localFile = null;
        if (repositoryRef != null) {
            Repository repository = this.getRepositoryManager().getRepositoryById(repositoryRef);
            if (repository == null) {
                throw new FetcherException((Throwable)new InvalidRepositoryException("Undefined repository " + repositoryRef));
            }
            this.resolveArtifact(repository, groupId, artifactId, version, classifier, type);
        } else {
            for (Repository repository : this.getRepositoryManager()) {
                if (repository.getType() != RepositoryKind.MAVEN_2) continue;
                this.resolveArtifact(repository, groupId, artifactId, version, classifier, type);
                if (this.localFile == null || !this.localFile.exists()) continue;
                break;
            }
        }
        if (this.localFile == null || !this.localFile.exists()) {
            throw new FetcherException((Throwable)new ResourceNotFoundException(maven2Deployment.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveArtifact(Repository repository, String groupId, String artifactId, String version, String classifier, String type) throws FetcherException {
        URL repositoryURL = null;
        try {
            repositoryURL = new URL(repository.getUrl());
        }
        catch (MalformedURLException e) {
            logger.debug((Object)"Invalid repository URL {0}", new Object[]{repository});
        }
        if (repositoryURL == null) {
            logger.debug((Object)("Invalid repository URL:" + repository), new Object[0]);
            return;
        }
        String maven2Version = Maven2Utils.getMaven2Version(repositoryURL.toExternalForm(), groupId, artifactId, version, 3000);
        try {
            this.foundURL = Maven2Utils.getMaven2URL(repositoryURL.toExternalForm(), groupId, artifactId, version, maven2Version, classifier, type);
        }
        catch (MalformedURLException e) {
            logger.debug((Object)("Invalid resource URL:" + e.getMessage()), new Object[0]);
        }
        this.localFile = "file".equals(repositoryURL.getProtocol()) ? URLUtils.urlToFile((URL)this.foundURL) : Maven2Utils.getMaven2File(this.localRepositoriesBaseDir + File.separator + repository.getId(), groupId, artifactId, version, maven2Version, classifier, type);
        this.lastModified = this.localFile.lastModified();
        if ("http".equals(repositoryURL.getProtocol()) && (!this.localFile.exists() || this.hasChanged())) {
            InputStream inputStream = null;
            logger.info((Object)"Downloading {0}...", new Object[]{this.localFile.getName()});
            try {
                URLConnection connection = this.foundURL.openConnection();
                connection.setReadTimeout(3000);
                Maven2Utils.addAuthenticationOnURL(connection);
                inputStream = connection.getInputStream();
                if (!this.localFile.getParentFile().exists()) {
                    this.localFile.getParentFile().mkdirs();
                }
                FileUtils.dump((InputStream)inputStream, (File)this.localFile);
                logger.info((Object)"Downloaded {0} ({1}Ko)", new Object[]{this.localFile.getName(), connection.getContentLength() / 1000});
                this.localFile.setLastModified(connection.getLastModified());
                if (this.verifyChecksum()) {
                    logger.debug((Object)"Resource {0} successfully downloaded", new Object[]{this.foundURL});
                } else {
                    logger.error((Object)"Bad checksum: file {0} may be corrupted", new Object[]{this.localFile});
                }
            }
            catch (FileNotFoundException e) {
                this.localFile.getParentFile().delete();
                logger.debug((Object)"File {0} has not been found on the repository ''{1}''", new Object[]{this.foundURL, repository});
            }
            catch (Exception e) {
                this.localFile.getParentFile().delete();
                logger.error((Object)"Exception while copying data from resource {0} from the repository ''{1}'' : {2}", new Object[]{this.foundURL, repository, e.getMessage()});
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void update() throws FetcherException {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyChecksum() {
        String remoteChecksumPath = this.foundURL.toExternalForm().concat(".md5");
        InputStream inputStream = null;
        try {
            String localChecksum = FileUtils.calculateChecksum((File)this.localFile, (String)"MD5");
            URL checksumURL = new URL(remoteChecksumPath);
            URLConnection connection = checksumURL.openConnection();
            Maven2Utils.addAuthenticationOnURL(connection);
            connection.setReadTimeout(3000);
            inputStream = connection.getInputStream();
            String remoteChecksum = Maven2Utils.readChecksum(inputStream);
            boolean bl = localChecksum.equals(remoteChecksum);
            return bl;
        }
        catch (FileNotFoundException e) {
            String port = "";
            if (this.foundURL.getPort() != -1) {
                port = ":" + this.foundURL.getPort();
            }
            String url = this.foundURL.getProtocol() + "://" + this.foundURL.getHost() + port + this.foundURL.getPath();
            logger.warn((Object)"Unable to validate checksum: no MD5 found on the remote repository ''{0}'' for the archive ''{1}''", new Object[]{url, this.localFile});
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

