/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer.impl.condition.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.ow2.util.plan.deployer.impl.condition.script.ForwardingScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptEngineFactory
extends ForwardingScriptEngineFactory {
    private static final String ENVIRONMENT_JS = "environment.js";
    private ScriptEngineFactory scriptEngineFactory;

    public void setScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        if (!this.isJavaScriptEngine(scriptEngineFactory)) {
            throw new RuntimeException("Expecting a JavaScript engine");
        }
        this.scriptEngineFactory = scriptEngineFactory;
    }

    private boolean isJavaScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        for (String mimeType : scriptEngineFactory.getMimeTypes()) {
            if (!"application/javascript".equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ScriptEngineFactory delegate() {
        return this.scriptEngineFactory;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        ScriptEngine engine = super.getScriptEngine();
        this.evaluateResource(engine, "SystemPropertyInfo.js");
        this.evaluateResource(engine, ENVIRONMENT_JS);
        return engine;
    }

    private void evaluateResource(ScriptEngine engine, String resourceName) {
        this.evaluateResource(engine, RhinoScriptEngineFactory.class, resourceName);
    }

    protected void evaluateResource(ScriptEngine engine, Class<?> site, String resourceName) {
        Reader reader = null;
        try {
            reader = this.getResourceReader(site, resourceName);
            engine.eval(reader);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Cannot execute script " + resourceName, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load script " + resourceName, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Reader getResourceReader(Class<?> site, String name) throws IOException {
        InputStream is = site.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Cannot load resource '" + name + "' from " + site);
        }
        return new InputStreamReader(is);
    }
}

