/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.osgi.framework.BundleContext;
import org.ow2.util.plan.deployer.impl.condition.script.RhinoScriptEngineFactory;

public class OSGiAwareScriptEngineFactory
extends RhinoScriptEngineFactory {
    private BundleContext bundleContext;

    public OSGiAwareScriptEngineFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ScriptEngine getScriptEngine() {
        ScriptEngine engine = super.getScriptEngine();
        engine.put("bundleContext", this.bundleContext);
        this.evaluateResource(engine, "Converters.js");
        this.evaluateResource(engine, "BundleInfo.js");
        this.evaluateResource(engine, "ServiceInfo.js");
        this.evaluateResource(engine, "osgi-environment.js");
        return engine;
    }

    private void evaluateResource(ScriptEngine engine, String resourceName) {
        Reader reader = null;
        try {
            reader = this.getResourceReader(resourceName);
            engine.eval(reader);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Cannot execute script " + resourceName, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load script " + resourceName, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Reader getResourceReader(String name) throws IOException {
        InputStream is = OSGiAwareScriptEngineFactory.class.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Cannot load resource '" + name + "' from " + OSGiAwareScriptEngineFactory.class);
        }
        return new InputStreamReader(is);
    }
}

