/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.lib.osgi.Processor;
import aQute.libg.command.Command;
import aQute.libg.generics.Create;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectLauncher {
    private final Project project;
    private long timeout = 3600000L;
    private final Collection<String> classpath = new ArrayList<String>();
    private final List<String> runbundles = Create.list();
    private final List<String> runvm = new ArrayList<String>();
    private final Map<String, String> runproperties;
    private Command java;
    private final Map<String, Map<String, String>> runsystempackages;
    private final List<String> activators = Create.list();
    private boolean trace;
    private boolean keep;
    private int framework;
    public static final int SERVICES = 10111;
    public static final int NONE = 20123;
    public static final int OK = 0;
    public static final int WARNING = -1;
    public static final int ERROR = -2;
    public static final int TIMEDOUT = -3;
    public static final int UPDATE_NEEDED = -4;
    public static final int CANCELED = -5;
    public static final int DUPLICATE_BUNDLE = -6;
    public static final int RESOLVE_ERROR = -7;
    public static final int ACTIVATOR_ERROR = -8;
    public static final int CUSTOM_LAUNCHER = -128;
    public static final String EMBEDDED_ACTIVATOR = "Embedded-Activator";

    public ProjectLauncher(Project project) throws Exception {
        this.project = project;
        for (File file : project.toFile(project.getRunbundles())) {
            this.runbundles.add(file.getAbsolutePath());
        }
        File[] builds = project.build();
        if (builds != null) {
            for (File file : builds) {
                this.runbundles.add(file.getAbsolutePath());
            }
        }
        Collection<Container> runpath = project.getRunpath();
        this.runsystempackages = project.parseHeader(project.getProperty("-runsystempackages"));
        this.framework = this.getRunframework(project.getProperty("-runframework"));
        this.trace = Processor.isTrue(project.getProperty("-runtrace"));
        for (Container c : runpath) {
            this.addClasspath(c);
        }
        this.runvm.addAll(project.getRunVM());
        this.runproperties = project.getRunProperties();
    }

    private int getRunframework(String property) {
        if ("none".equalsIgnoreCase(property)) {
            return 20123;
        }
        if ("services".equalsIgnoreCase(property)) {
            return 10111;
        }
        return 10111;
    }

    public void addClasspath(Container container) throws Exception {
        if (container.getError() != null) {
            this.project.error("Cannot launch because %s has reported %s", container.getProject(), container.getError());
        } else {
            List<Container> members = container.getMembers();
            for (Container m : members) {
                String path = m.getFile().getAbsolutePath();
                if (this.classpath.contains(path)) continue;
                this.classpath.add(path);
                Manifest manifest = m.getManifest();
                if (manifest == null) continue;
                Map<String, Map<String, String>> exports = this.project.parseHeader(manifest.getMainAttributes().getValue("Export-Package"));
                for (Map.Entry<String, Map<String, String>> e : exports.entrySet()) {
                    if (this.runsystempackages.containsKey(e.getKey())) continue;
                    this.runsystempackages.put(e.getKey(), e.getValue());
                }
                String activator = manifest.getMainAttributes().getValue(EMBEDDED_ACTIVATOR);
                if (activator == null) continue;
                this.activators.add(activator);
            }
        }
    }

    public void addRunBundle(String f) {
        this.runbundles.add(f);
    }

    public Collection<String> getRunBundles() {
        return this.runbundles;
    }

    public void addRunVM(String arg) {
        this.runvm.add(arg);
    }

    public Collection<String> getRunpath() {
        return this.classpath;
    }

    public Collection<String> getClasspath() {
        return this.classpath;
    }

    public Collection<String> getRunVM() {
        return this.runvm;
    }

    public Collection<String> getArguments() {
        return Collections.emptySet();
    }

    public Map<String, String> getRunProperties() {
        return this.runproperties;
    }

    public abstract String getMainTypeName();

    public abstract void update() throws Exception;

    public int launch() throws Exception {
        int result;
        this.prepare();
        this.java = new Command();
        this.java.add(this.project.getProperty("java", "java"));
        this.java.add("-cp");
        this.java.add(Processor.join(this.getClasspath(), File.pathSeparator));
        this.java.addAll(this.getRunVM());
        this.java.add(this.getMainTypeName());
        this.java.addAll(this.getArguments());
        if (this.timeout != 0L) {
            this.java.setTimeout(this.timeout + 1000L, TimeUnit.MILLISECONDS);
        }
        if ((result = this.java.execute(System.in, (Appendable)System.out, (Appendable)System.err)) == Integer.MIN_VALUE) {
            return -3;
        }
        this.reportResult(result);
        return result;
    }

    protected void reportResult(int result) {
        switch (result) {
            case 0: {
                this.project.trace("Command terminated normal %s", this.java);
                break;
            }
            case -3: {
                this.project.error("Launch timedout: %s", this.java);
                break;
            }
            case -2: {
                this.project.error("Launch errored: %s", this.java);
                break;
            }
            case -1: {
                this.project.warning("Launch had a warning %s", this.java);
                break;
            }
            default: {
                this.project.warning("Unknown code %d from launcher: %s", result, this.java);
            }
        }
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void cancel() {
        this.java.cancel();
    }

    public Map<String, Map<String, String>> getSystemPackages() {
        return this.runsystempackages;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public void setTrace(boolean level) {
        this.trace = level;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public abstract void prepare() throws Exception;

    public Project getProject() {
        return this.project;
    }

    public boolean addActivator(String e) {
        return this.activators.add(e);
    }

    public Collection<String> getActivators() {
        return Collections.unmodifiableCollection(this.activators);
    }

    public int getRunFramework() {
        return this.framework;
    }

    public void setRunFramework(int n) {
        assert (n == 20123 || n == 10111);
        this.framework = n;
    }

    public void addDefault(String defaultSpec) throws Exception {
        List<Container> deflts = this.project.getBundles(1, defaultSpec);
        for (Container c : deflts) {
            this.addClasspath(c);
        }
    }
}

