/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repo.eclipse;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.libg.generics.Create;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseRepo
implements Plugin,
RepositoryPlugin {
    File root;
    Reporter reporter;
    String name;
    Map<String, Map<String, String>> index;
    public static String LOCATION = "location";
    public static String NAME = "name";

    @Override
    public void setProperties(Map<String, String> map) {
        String location = map.get(LOCATION);
        if (location == null) {
            throw new IllegalArgumentException("Location muse be set on a EclipseRepo plugin");
        }
        this.root = new File(location);
        if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("Repository is not a valid directory " + this.root);
        }
        if (!new File(this.root, "plugins").isDirectory()) {
            throw new IllegalArgumentException("Repository is not a valid directory (no plugins directory)" + this.root);
        }
        this.name = map.get(NAME);
        try {
            this.index = this.buildIndex();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build index for eclipse repo: " + this.root);
        }
    }

    Map<String, Map<String, String>> buildIndex() throws Exception {
        File[] plugins;
        File index = new File(this.root, "bnd.index").getAbsoluteFile();
        for (File f : plugins = new File(this.root, "plugins").listFiles()) {
            if (!(f = f.getAbsoluteFile()).isFile() || f.lastModified() <= index.lastModified()) continue;
            Map<String, Map<String, String>> map = this.buildIndex(plugins);
            this.write(index, map);
            return map;
        }
        String s = this.read(index);
        return Processor.parseHeader(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(File index) throws Exception {
        if (index.isFile()) {
            BufferedReader fr = new BufferedReader(new FileReader(index));
            StringBuilder sb = new StringBuilder();
            try {
                String s = fr.readLine();
                while (s != null) {
                    sb.append(s);
                    s = fr.readLine();
                }
            }
            finally {
                fr.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File index, Map<String, Map<String, String>> map) throws Exception {
        String s = Processor.printClauses(map, null);
        index.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(index);
        try {
            fw.write(s);
        }
        finally {
            fw.close();
        }
    }

    private Map<String, Map<String, String>> buildIndex(File[] plugins) {
        Map<String, Map<String, String>> map = Create.map();
        for (File plugin : plugins) {
            try {
                Map<String, String> instance;
                Jar jar = new Jar(plugin);
                Manifest manifest = jar.getManifest();
                String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                String version = manifest.getMainAttributes().getValue("Bundle-Version");
                if (bsn == null) continue;
                if (version == null) {
                    version = "0";
                }
                if ((instance = map.get(bsn)) == null) {
                    instance = Create.map();
                }
                instance.put(version, plugin.getAbsolutePath());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public File[] get(String bsn, String range) throws Exception {
        VersionRange r = new VersionRange(range);
        Map<String, String> instances = this.index.get(bsn);
        if (instances == null) {
            return null;
        }
        List<File> result = Create.list();
        for (String version : instances.keySet()) {
            File f;
            Version v = new Version(version);
            if (!r.includes(v) || !(f = new File(instances.get(version))).isFile()) continue;
            result.add(f);
        }
        return result.toArray(new File[result.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> list(String regex) {
        Instruction pattern = null;
        if (regex != null) {
            pattern = Instruction.getPattern(regex);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String f : this.index.keySet()) {
            if (pattern != null && !pattern.matches(f)) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    public File put(Jar jar) throws Exception {
        return null;
    }

    @Override
    public List<Version> versions(String bsn) {
        Map<String, String> instances = this.index.get(bsn);
        if (instances == null) {
            return null;
        }
        List<Version> versions = Create.list();
        for (String v : instances.keySet()) {
            versions.add(new Version(v));
        }
        return versions;
    }
}

