/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployerList;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployer<T extends IDeployable<T>>
extends AbsDeployerList<T> {
    private Log logger = LogFactory.getLog(AbsDeployer.class);
    protected Map<URL, IDeployable<T>> deployedDeployables = new HashMap<URL, IDeployable<T>>();

    public abstract void doDeploy(IDeployable<T> var1) throws DeployerException;

    public abstract void doUndeploy(IDeployable<T> var1) throws DeployerException;

    public abstract boolean supports(IDeployable<?> var1);

    public void deploy(final IDeployable<T> deployable) throws DeployerException {
        this.check(deployable);
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult res = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Void>(){

            public Void execute() throws Exception {
                AbsDeployer.this.doDeploy(deployable);
                return null;
            }
        });
        res.getResult();
        if (res.hasException()) {
            if (res.getException() instanceof DeployerException) {
                throw (DeployerException)((Object)res.getException());
            }
            throw new DeployerException("Unable to deploy deployable '" + deployable + "'", (Throwable)res.getException());
        }
        this.deployedDeployables.put(this.getURL(deployable), deployable);
    }

    public void undeploy(final IDeployable<T> deployable) throws DeployerException {
        this.check(deployable);
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult res = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Void>(){

            public Void execute() throws Exception {
                AbsDeployer.this.doUndeploy(deployable);
                return null;
            }
        });
        res.getResult();
        if (res.hasException()) {
            if (res.getException() instanceof DeployerException) {
                throw (DeployerException)((Object)res.getException());
            }
            throw new DeployerException("Unable to undeploy deployable '" + deployable + "'", (Throwable)res.getException());
        }
        this.deployedDeployables.remove(this.getURL(deployable));
    }

    public void stop() {
        for (IDeployable<T> deployable : new ArrayList<IDeployable<T>>(this.deployedDeployables.values())) {
            try {
                this.undeploy(deployable);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot undeploy the deployable ''{0}''", new Object[]{deployable, e});
            }
        }
    }

    protected URL getURL(IDeployable<T> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", (Throwable)e);
        }
        return url;
    }

    protected File getFile(IDeployable<T> deployable) throws DeployerException {
        return URLUtils.urlToFile((URL)this.getURL(deployable));
    }

    public boolean isDeployed(IDeployable<T> deployable) throws DeployerException {
        this.check(deployable);
        return this.deployedDeployables.containsKey(this.getURL(deployable));
    }

    public Map<URL, IDeployable<T>> getDeployedDeployables() {
        return this.deployedDeployables;
    }

    protected void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    @Override
    public List<IDeploymentReport> deploy(List<IDeployable<T>> deployables) {
        List<IDeploymentReport> deploymentReports = this.doDeploy(deployables);
        for (IDeploymentReport deploymentReport : deploymentReports) {
            if (!deploymentReport.isDeploymentOk()) continue;
            IDeployable deployable = deploymentReport.getDeployable();
            try {
                this.deployedDeployables.put(this.getURL(deployable), deployable);
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Cannot add deployable ''{0}'' to the list of deployed deployables", new Object[]{deployable, e});
            }
        }
        return deploymentReports;
    }

    public List<IDeploymentReport> doDeploy(List<IDeployable<T>> deployables) {
        return super.deploy(deployables);
    }

    @Override
    public List<IDeploymentReport> undeploy(List<IDeployable<T>> deployables) {
        List<IDeploymentReport> deploymentReports = this.doUndeploy(deployables);
        for (IDeploymentReport deploymentReport : deploymentReports) {
            if (!deploymentReport.isDeploymentOk()) continue;
            IDeployable deployable = deploymentReport.getDeployable();
            try {
                this.deployedDeployables.remove(this.getURL(deployable));
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Cannot remove deployable ''{0}'' to the list of deployed deployables", new Object[]{deployable, e});
            }
        }
        return deploymentReports;
    }

    public List<IDeploymentReport> doUndeploy(List<IDeployable<T>> deployables) {
        return super.undeploy(deployables);
    }
}

