/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerReportCallback;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.ee.deploy.impl.deployer.DeployerManagerCallbackType;
import org.ow2.util.ee.deploy.impl.report.DeploymentReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployerManager
implements IDeployerManager {
    public static final String DEPLOYER_FACTORY_CLASS_NAME = DeployerManager.class.getName();
    private static Log logger = LogFactory.getLog(DeployerManager.class);
    private List<IDeployer> deployers = new ArrayList<IDeployer>();
    private List<IDeployerManagerCallback> callbacks = new ArrayList<IDeployerManagerCallback>();
    private List<IDeployerManagerReportCallback> reportCallbacks = new ArrayList<IDeployerManagerReportCallback>();

    public void register(IDeployer deployer) {
        if (deployer != null) {
            logger.debug((Object)"Registering deployer ''{0}''", new Object[]{deployer.getClass()});
            this.deployers.add(deployer);
        }
    }

    public void unregister(IDeployer deployer) {
        if (this.deployers.contains(deployer)) {
            logger.debug((Object)"Unregistering deployer ''{0}''", new Object[]{deployer});
            this.deployers.remove(deployer);
        } else {
            logger.warn((Object)"Cannot unregister the deployer ''{0}'' as it is not registered.", new Object[]{deployer});
        }
    }

    protected IDeployer findDeployerForDeployable(IDeployable<?> deployable) throws UnsupportedDeployerException {
        for (IDeployer deployer : this.deployers) {
            if (!deployer.supports(deployable)) continue;
            return deployer;
        }
        throw new UnsupportedDeployerException("No deployer was found for the deployable '" + deployable + "'.");
    }

    protected IDeployer findDeployerForDeployables(List<IDeployable<?>> deployables) throws UnsupportedDeployerException {
        for (IDeployer deployer : this.deployers) {
            if (!deployer.supports(deployables)) continue;
            return deployer;
        }
        StringBuffer sb = new StringBuffer();
        for (IDeployable<?> deployable : deployables) {
            sb.append("No deployer founded for the deployable '" + deployable + "\n");
        }
        throw new UnsupportedDeployerException(sb.toString());
    }

    public void deploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.callback(DeployerManagerCallbackType.PRE_DEPLOY, deployable);
        this.findDeployerForDeployable(deployable).deploy(deployable);
        this.callback(DeployerManagerCallbackType.POST_DEPLOY, deployable);
    }

    protected List<IDeploymentReport> doDeploymentOperation(List<IDeployable<?>> deployables, boolean isDeployOperation) {
        ArrayList<Object> deployablesOneTypeList = new ArrayList();
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        if (deployables.size() > 0) {
            deployablesOneTypeList.add(deployables.get(0));
            for (int i = 0; i < deployables.size() - 1; ++i) {
                if (deployables.get(i).getClass().getName().equals(deployables.get(i + 1).getClass().getName())) {
                    deployablesOneTypeList.add(deployables.get(i + 1));
                    continue;
                }
                if (isDeployOperation) {
                    deploymentReports.addAll(this.deployOneTypeList(deployablesOneTypeList));
                } else {
                    deploymentReports.addAll(this.undeployOneTypeList(deployablesOneTypeList));
                }
                deployablesOneTypeList = new ArrayList();
                deployablesOneTypeList.add(deployables.get(i + 1));
            }
            if (isDeployOperation) {
                deploymentReports.addAll(this.deployOneTypeList(deployablesOneTypeList));
            } else {
                deploymentReports.addAll(this.undeployOneTypeList(deployablesOneTypeList));
            }
        }
        return deploymentReports;
    }

    public List<IDeploymentReport> deploy(List<IDeployable<?>> deployables) {
        return this.doDeploymentOperation(deployables, true);
    }

    protected List<IDeploymentReport> deployOneTypeList(List<IDeployable<?>> deployables) {
        for (IDeployable<?> deployable : deployables) {
            this.reportCallback(DeployerManagerCallbackType.PRE_DEPLOY, deployable);
        }
        ArrayList<IDeploymentReport> deploymentReports = null;
        try {
            deploymentReports = this.findDeployerForDeployables(deployables).deploy(deployables);
        }
        catch (UnsupportedDeployerException e) {
            deploymentReports = new ArrayList<IDeploymentReport>();
            for (IDeployable<?> deployable : deployables) {
                DeploymentReport deploymentReport = new DeploymentReport();
                deploymentReport.setDeploymentOk(false);
                deploymentReport.setException((Exception)((Object)e));
                deploymentReport.setDeployable(deployable);
                deploymentReports.add(deploymentReport);
            }
        }
        if (deploymentReports != null) {
            for (IDeploymentReport deploymentReport : deploymentReports) {
                this.reportCallback(DeployerManagerCallbackType.POST_DEPLOY, deploymentReport);
            }
        }
        return deploymentReports;
    }

    protected List<IDeploymentReport> undeployOneTypeList(List<IDeployable<?>> deployables) {
        ArrayList<IDeploymentReport> deploymentReports;
        for (IDeployable<?> deployable : deployables) {
            this.reportCallback(DeployerManagerCallbackType.PRE_UNDEPLOY, deployable);
        }
        try {
            deploymentReports = this.findDeployerForDeployables(deployables).undeploy(deployables);
        }
        catch (UnsupportedDeployerException e) {
            deploymentReports = new ArrayList<IDeploymentReport>();
            for (IDeployable<?> deployable : deployables) {
                DeploymentReport deploymentReport = new DeploymentReport();
                deploymentReport.setDeploymentOk(false);
                deploymentReport.setDeployable(deployable);
                deploymentReport.setException((Exception)((Object)e));
                deploymentReports.add(deploymentReport);
            }
        }
        if (deploymentReports != null) {
            for (IDeploymentReport deploymentReport : deploymentReports) {
                this.reportCallback(DeployerManagerCallbackType.POST_UNDEPLOY, deploymentReport);
            }
        }
        return deploymentReports;
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.callback(DeployerManagerCallbackType.PRE_UNDEPLOY, deployable);
        this.findDeployerForDeployable(deployable).undeploy(deployable);
        this.callback(DeployerManagerCallbackType.POST_UNDEPLOY, deployable);
    }

    public List<IDeploymentReport> undeploy(List<IDeployable<?>> deployables) {
        return this.doDeploymentOperation(deployables, false);
    }

    public List<String> getDeployerClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        for (IDeployer deployer : this.deployers) {
            classes.add(deployer.getClass().getName());
        }
        return classes;
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        return this.findDeployerForDeployable(deployable).isDeployed(deployable);
    }

    public void addCallback(IDeployerManagerCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        } else {
            logger.warn((Object)"Callback already added", new Object[0]);
        }
    }

    public void removeCallback(IDeployerManagerCallback callback) {
        if (!this.callbacks.contains(callback)) {
            logger.warn((Object)"Callback doesn't exist", new Object[0]);
        } else {
            this.callbacks.remove(callback);
        }
    }

    public void addCallback(IDeployerManagerReportCallback callback) {
        if (!this.reportCallbacks.contains(callback)) {
            this.reportCallbacks.add(callback);
        } else {
            logger.warn((Object)"Callback already added", new Object[0]);
        }
    }

    public void removeCallback(IDeployerManagerReportCallback callback) {
        if (!this.reportCallbacks.contains(callback)) {
            logger.warn((Object)"Callback doesn't exist", new Object[0]);
        } else {
            this.reportCallbacks.remove(callback);
        }
    }

    private void callback(DeployerManagerCallbackType type, IDeployable<?> deployable) {
        for (IDeployerManagerCallback callback : this.callbacks) {
            try {
                switch (type) {
                    case PRE_DEPLOY: {
                        callback.preDeploy(deployable);
                        break;
                    }
                    case POST_DEPLOY: {
                        callback.postDeploy(deployable);
                        break;
                    }
                    case PRE_UNDEPLOY: {
                        callback.preUndeploy(deployable);
                        break;
                    }
                    case POST_UNDEPLOY: {
                        callback.postUndeploy(deployable);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error during the execution of the ''{0}'' callback for ''{1}''", new Object[]{type, deployable.getArchive(), t});
                t.printStackTrace();
            }
        }
    }

    private void reportCallback(DeployerManagerCallbackType type, IDeploymentReport deploymentReport) {
        for (IDeployerManagerReportCallback reportCallback : this.reportCallbacks) {
            try {
                switch (type) {
                    case POST_DEPLOY: {
                        reportCallback.postDeploy(deploymentReport);
                        break;
                    }
                    case POST_UNDEPLOY: {
                        reportCallback.postUndeploy(deploymentReport);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error during the execution of the ''{0}'' callback for ''{1}''", new Object[]{type, deploymentReport.getDeployable().getArchive(), t});
                t.printStackTrace();
            }
        }
    }

    private void reportCallback(DeployerManagerCallbackType type, IDeployable<?> deployable) {
        for (IDeployerManagerReportCallback reportCallback : this.reportCallbacks) {
            try {
                switch (type) {
                    case PRE_DEPLOY: {
                        reportCallback.preDeploy(deployable);
                        break;
                    }
                    case PRE_UNDEPLOY: {
                        reportCallback.preUndeploy(deployable);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error during the execution of the ''{0}'' callback for ''{1}''", new Object[]{type, deployable.getArchive(), t});
                t.printStackTrace();
            }
        }
    }
}

