/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerReportCallback;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.impl.deployer.DeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableAnalyserTracker;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperComponent;
import org.ow2.util.ee.deploy.impl.osgi.OSGiDeployer;

public class Activator
implements BundleActivator,
ServiceListener {
    private BundleContext bundleContext = null;
    private DeployerManager deployerManager = null;
    private DeployableAnalyserTracker deployableAnalyserTracker = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        OSGiDeployer osgiDeployer = new OSGiDeployer(bundleContext);
        this.deployerManager = new DeployerManager();
        this.deployerManager.register(osgiDeployer);
        this.deployableAnalyserTracker = new DeployableAnalyserTracker(bundleContext);
        this.deployableAnalyserTracker.start();
        DeployableHelperComponent deployableHelperComponent = new DeployableHelperComponent(this.deployableAnalyserTracker);
        bundleContext.registerService(IDeployerManager.class.getName(), (Object)this.deployerManager, null);
        bundleContext.registerService(IDeployer.class.getName(), (Object)osgiDeployer, null);
        bundleContext.registerService(IDeployableHelper.class.getName(), (Object)deployableHelperComponent, null);
        ArchiveManager archiveManager = ArchiveManager.getInstance();
        bundleContext.registerService(IArchiveManager.class.getName(), (Object)archiveManager, null);
        this.addCallbacks();
        bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + IDeployerManagerCallback.class.getName() + ")");
        bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + IDeployerManagerReportCallback.class.getName() + ")");
    }

    public void stop(BundleContext bc) {
        this.deployableAnalyserTracker.stop();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object object = this.bundleContext.getService(serviceRef);
        switch (event.getType()) {
            case 1: {
                if (object instanceof IDeployerManagerCallback) {
                    this.deployerManager.addCallback((IDeployerManagerCallback)IDeployerManagerCallback.class.cast(object));
                    break;
                }
                if (!(object instanceof IDeployerManagerReportCallback)) break;
                this.deployerManager.addCallback((IDeployerManagerReportCallback)IDeployerManagerReportCallback.class.cast(object));
                break;
            }
            case 4: {
                if (object instanceof IDeployerManagerCallback) {
                    this.deployerManager.removeCallback((IDeployerManagerCallback)IDeployerManagerCallback.class.cast(object));
                    break;
                }
                if (!(object instanceof IDeployerManagerReportCallback)) break;
                this.deployerManager.removeCallback((IDeployerManagerReportCallback)IDeployerManagerReportCallback.class.cast(object));
                break;
            }
        }
    }

    private void addCallbacks() throws InvalidSyntaxException {
        IDeployerManagerCallback callback;
        ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(IDeployerManagerCallback.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                callback = (IDeployerManagerCallback)this.bundleContext.getService(serviceReference);
                this.deployerManager.addCallback(callback);
            }
        }
        if ((serviceReferences = this.bundleContext.getServiceReferences(IDeployerManagerReportCallback.class.getName(), null)) != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                callback = (IDeployerManagerReportCallback)this.bundleContext.getService(serviceReference);
                this.deployerManager.addCallback((IDeployerManagerReportCallback)callback);
            }
        }
    }
}

