/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.jonas.antmodular.bootstrap.BootstrapTask;
import org.ow2.jonas.antmodular.bootstrap.JOnASAntTool;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.Tasks;

public abstract class AbstractJOnASBaseAntTask
extends Task {
    protected File jonasRoot = null;
    protected File destDir = null;
    protected List tasks = new ArrayList();
    protected static final String CONF_DIR = "/conf";
    protected boolean skipOptionalDeployablesCopy = false;

    protected AbstractJOnASBaseAntTask() {
    }

    public void execute() {
        this.jonasRoot = new File(this.getJOnASRoot());
        this.destDir = new File(this.getJOnASBase());
        if (this.jonasRoot == null) {
            throw new BuildException("jonasRoot element is not set");
        }
        if (this.destDir == null) {
            throw new BuildException("destDir element is not set");
        }
        if (this.jonasRoot.getPath().equals(this.destDir.getPath())) {
            throw new BuildException("jonasRoot and destDir is the same path !");
        }
    }

    public void executeAllTask() {
        for (Object o : this.tasks) {
            BaseTaskItf task;
            if (o instanceof BaseTaskItf) {
                task = (BaseTaskItf)o;
                task.setDestDir(this.destDir);
                task.setJonasRoot(this.jonasRoot);
                if (task instanceof BootstrapTask) {
                    ((BootstrapTask)((Object)task)).setJonasBase(this.destDir);
                }
                JOnASAntTool.configure(this, (Task)task);
                String info = task.getLogInfo();
                if (info != null) {
                    this.log(info, 2);
                }
                task.execute();
                continue;
            }
            task = (Task)o;
            JOnASAntTool.configure(this, (Task)task);
            task.execute();
        }
    }

    public void addTasks(Tasks subTasks) {
        if (subTasks != null) {
            Iterator<Task> it = subTasks.getTasks().iterator();
            while (it.hasNext()) {
                this.tasks.add(it.next());
            }
        }
    }

    public void addTask(BaseTaskItf task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    public List getTasks() {
        return this.tasks;
    }

    protected JTask createServiceNameReplace(String serviceName, String info, String confDir, String property) {
        JTask jtask = new JTask();
        jtask.setDestDir(this.destDir);
        jtask.changeValueForKey(info, confDir, "jonas.properties", property, serviceName, false);
        jtask.setLogInfo(info + "Setting service to : " + serviceName);
        return jtask;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public String getJOnASRoot() {
        return this.getProject().getProperty("jonas.root");
    }

    public String getJOnASBase() {
        return this.getProject().getProperty("jonas.base");
    }

    protected void copyTemplateDeployables(String resourcePackage) {
        String templatePackage = resourcePackage.trim();
        if (!templatePackage.endsWith("/")) {
            templatePackage = templatePackage + "/";
        }
        String resourcePattern = templatePackage + ".+";
        Pattern pattern = Pattern.compile(resourcePattern);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("templates");
        String jarFileName = null;
        try {
            jarFileName = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Cannot build jar filename from url " + url, (Throwable)e);
        }
        jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFileName);
        }
        catch (IOException e) {
            throw new BuildException("Cannot build jar file from url " + url, (Throwable)e);
        }
        ArrayList<String> resources = new ArrayList<String>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String name = jarEntry.getName();
            if (!pattern.matcher(name).matches()) continue;
            resources.add(name);
        }
        for (String resource : resources) {
            FileOutputStream outputStream;
            String name = resource.substring(resource.lastIndexOf("/") + 1, resource.length());
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) {
                throw new BuildException("Resource " + resource + " cannot be found.");
            }
            File deployDir = new File(new File(this.getJOnASBase(), "deploy"), name);
            try {
                outputStream = new FileOutputStream(deployDir);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("File " + deployDir.getAbsolutePath() + " cannot be found", (Throwable)e);
            }
            try {
                ((OutputStream)outputStream).write(this.inputStream2Byte(inputStream));
            }
            catch (IOException e) {
                throw new BuildException("Cannot copy resource " + name + " to " + deployDir.getAbsolutePath(), (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new BuildException("Cannot close outpustream of the resource " + deployDir.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    private byte[] inputStream2Byte(InputStream inputStream) {
        int size = 1024;
        byte[] buffer = new byte[size];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int length;
            while ((length = inputStream.read(buffer, 0, size)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot convert inpustream to byte[]", (Throwable)e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setSkipOptionalDeployablesCopy(boolean skipOptionalDeployablesCopy) {
        this.skipOptionalDeployablesCopy = skipOptionalDeployablesCopy;
    }
}

