/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployable;

import java.util.Comparator;
import java.util.List;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonProvidesRequirements;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonProvidesRequirementsComparator
implements Comparator<AddonProvidesRequirements> {
    @Override
    public int compare(AddonProvidesRequirements o1, AddonProvidesRequirements o2) {
        List<String> provides1 = o1.getProvides();
        List<String> provides2 = o2.getProvides();
        List<String> requirements1 = o1.getRequirements();
        List<String> requirements2 = o2.getRequirements();
        boolean doesO1RequireO2 = this.doesO1RequireO2(requirements1, provides2);
        boolean doesO2RequireO1 = this.doesO1RequireO2(requirements2, provides1);
        if (doesO1RequireO2 && !doesO2RequireO1) {
            return 1;
        }
        if (doesO2RequireO1 && !doesO1RequireO2) {
            return -1;
        }
        return 0;
    }

    private boolean doesO1RequireO2(List<String> requirements, List<String> provides) {
        if (requirements != null) {
            for (String requirement : requirements) {
                if (!AddonUtil.checkRequirement(requirement, provides)) continue;
                return true;
            }
        }
        return false;
    }
}

