/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.addon.deploy.impl.util.Range;
import org.ow2.jonas.addon.properties.ServicePropertiesImpl;
import org.ow2.jonas.properties.ServiceProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonMetaData {
    public static final String NAME_ELEMENT = "name";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String TENNANT_ID_ELEMENT = "tenant-id";
    public static final String INSTANCE_ELEMENT = "instance";
    public static final String LICENCE_ELEMENT = "licence";
    public static final String JONAS_VERSION_ELEMENT = "jonas-version";
    public static final String AUTOSTART_ELEMENT = "autostart";
    public static final String JVM_VERSION_ELEMENT = "jvm-version";
    public static final String PROVIDES_ELEMENT = "provides";
    public static final String REQUIREMENTS_ELEMENT = "requirements";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String AUTHOR_ELEMENT = "author";
    public static final String PROVIDES_SEPARATOR = " ";
    public static final String REQUIREMENT_SEPARATOR = " ";
    private String name;
    private String description;
    private String tenantId;
    private String instance;
    private String author;
    private String licence;
    private Range jonasVersions;
    private Boolean autostart = false;
    private Range jvmVersions;
    private List<String> provides = new ArrayList<String>();
    private List<String> requirements = new ArrayList<String>();
    private ServiceProperties serviceProperties;
    private File addonMetaDataFile;
    private String service;
    private String implementation;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLicence() {
        return this.licence;
    }

    public boolean isJOnASVersionSupported(String jonasVersion) {
        return this.jonasVersions != null && this.jonasVersions.isSupported(jonasVersion);
    }

    public Boolean getAutostart() {
        return this.autostart;
    }

    public boolean isJvmVersionSupported(String jvmVersion) {
        return this.jvmVersions != null && this.jvmVersions.isSupported(jvmVersion);
    }

    public List<String> getProvides() {
        return this.provides;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public void setJonasVersions(Range jonasVersions) {
        this.jonasVersions = jonasVersions;
    }

    public void setAutostart(Boolean autostart) {
        this.autostart = autostart;
    }

    public void setJvmVersions(Range jvmVersions) {
        this.jvmVersions = jvmVersions;
    }

    public void setProvides(String provides) {
        this.provides = AddonUtil.getTokens(provides, " ");
    }

    public void setRequirements(String requirements) {
        this.requirements = AddonUtil.getTokens(requirements, " ");
    }

    public void setServiceProperties(Properties properties) {
        this.serviceProperties = new ServicePropertiesImpl(properties, this.service);
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public File getAddonMetaDataFile() {
        return this.addonMetaDataFile;
    }

    public void setAddonMetaDataFile(File addonMetaDataFile) {
        this.addonMetaDataFile = addonMetaDataFile;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public boolean isJOnASService() {
        return this.service != null;
    }
}

