/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import org.ow2.jonas.jmx.Interceptor;
import org.ow2.jonas.jmx.internal.interceptor.InvocationContextImpl;

public class InvocationHandlerImpl
implements InvocationHandler {
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private InvocationHandlerImpl delegate;
    private MBeanServer target;

    public InvocationHandlerImpl() {
    }

    public InvocationHandlerImpl(MBeanServer target) {
        this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.interceptors.size() > 0) {
            InvocationContextImpl invocationContextImpl = new InvocationContextImpl(method, args, this.interceptors, this.target);
            return invocationContextImpl.proceed();
        }
        if (this.delegate == null) {
            throw new Exception("Invocation handler delegate not set");
        }
        return this.delegate.invoke(proxy, method, args);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    public InvocationHandlerImpl getDelegate() {
        return this.delegate;
    }

    public void setDelegate(InvocationHandlerImpl delegate) {
        this.delegate = delegate;
    }
}

