/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.distributed.globallock.lib;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLock;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockException;
import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockManager;
import org.objectweb.perseus.concurrency.distributed.globallock.lib.GlobalLockUser;
import org.objectweb.perseus.distribution.api.DistResCoordinatorFactory;
import org.objectweb.perseus.distribution.api.DistResServiceManager;
import org.objectweb.perseus.distribution.api.DistResUser;
import org.objectweb.perseus.distribution.api.DistResUserService;

public class BasicGlobalLockManager
implements GlobalLockManager,
BindingController,
LifeCycleController {
    public static final String SERVICE_MGR_BINDING = "dist-res-service-manager";
    public static final String COORD_FACTORY_BINDING = "dist-res-coord-factory";
    protected DistResServiceManager drsm;
    protected DistResCoordinatorFactory drcf;
    protected String state = "STOPPED";
    protected DistResUserService drus;
    protected Map globalLocks;
    protected Serializable nodeId;

    public String[] listFc() {
        return new String[]{SERVICE_MGR_BINDING, COORD_FACTORY_BINDING};
    }

    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (SERVICE_MGR_BINDING.equals(s)) {
            return this.drsm;
        }
        if (COORD_FACTORY_BINDING.equals(s)) {
            return this.drcf;
        }
        return null;
    }

    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!"STOPPED".equals(this.state)) {
            throw new IllegalLifeCycleException(s);
        }
        try {
            if (SERVICE_MGR_BINDING.equals(s)) {
                this.drsm = (DistResServiceManager)o;
            } else if (COORD_FACTORY_BINDING.equals(s)) {
                this.drcf = (DistResCoordinatorFactory)o;
            }
        }
        catch (ClassCastException e) {
            throw new IllegalBindingException(s + ":" + e.getMessage());
        }
    }

    public void unbindFc(String s) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!"STOPPED".equals(this.state)) {
            throw new IllegalLifeCycleException(s);
        }
        if (SERVICE_MGR_BINDING.equals(s)) {
            this.drus = null;
        } else if (SERVICE_MGR_BINDING.equals(s)) {
            this.drcf = null;
        }
    }

    public String getFcState() {
        return this.state;
    }

    public void startFc() throws IllegalLifeCycleException {
        if ("STARTED".equals(this.state)) {
            throw new IllegalLifeCycleException("Already started");
        }
        Serializable nodeId = this.drsm.newLocalNode(this.drcf);
        this.drus = this.drsm.getUserService((Object)nodeId);
        this.globalLocks = new HashMap();
        this.state = "STARTED";
    }

    public void stopFc() throws IllegalLifeCycleException {
        if ("STOPPED".equals(this.state)) {
            throw new IllegalLifeCycleException("Already stopped");
        }
        this.globalLocks = null;
        this.drsm.removeLocalNode((Object)this.drus.getNodeId());
        this.drus = null;
        this.state = "STOPPED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalLock getGlobalLock(Serializable oid, boolean create) throws GlobalLockException {
        GlobalLock gl;
        Map map = this.globalLocks;
        synchronized (map) {
            gl = (GlobalLock)this.globalLocks.get(oid);
            if (gl == null && create) {
                gl = this.createLock(oid);
                this.globalLocks.put(oid, gl);
                this.joinUsers(oid);
            }
        }
        return gl;
    }

    protected GlobalLock createLock(Serializable oid) {
        return new GlobalLockUser(oid, this.drus);
    }

    protected void joinUsers(Serializable oid) throws GlobalLockException {
        GlobalLockUser gl = (GlobalLockUser)this.globalLocks.get(oid);
        try {
            this.drus.joinUsers((Object)oid, (DistResUser)gl);
        }
        catch (Exception e) {
            throw new GlobalLockException(e);
        }
    }

    public Object getNodeId() {
        return this.nodeId;
    }
}

