/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.jonas.util;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class FileNamesComparator
implements Comparator<File>,
Serializable {
    private static final long serialVersionUID = 5127974197302050785L;
    private boolean directoriesFirst;
    private boolean ignoreCase;

    public FileNamesComparator() {
        this(false, false);
    }

    public FileNamesComparator(boolean directoriesFirst, boolean ignoreCase) {
        this.directoriesFirst = directoriesFirst;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public int compare(File file1, File file2) {
        if (file1 == file2) {
            return 0;
        }
        if (file1 == null) {
            return -1;
        }
        if (file2 == null) {
            return 1;
        }
        if (this.directoriesFirst) {
            if (file1.isDirectory() && !file2.isDirectory()) {
                return -1;
            }
            if (!file1.isDirectory() && file2.isDirectory()) {
                return 1;
            }
        }
        if (this.ignoreCase) {
            return file1.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        }
        return file1.getName().compareTo(file2.getName());
    }

    public boolean isDirectoriesFirst() {
        return this.directoriesFirst;
    }

    public void setDirectoriesFirst(boolean directoriesFirst) {
        this.directoriesFirst = directoriesFirst;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

