/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.jvm.internal;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.jvm.generated.Jvm;
import org.ow2.jonas.report.extensions.jvm.generated.PropertyType;
import org.ow2.jonas.report.extensions.jvm.generated.SystemPropertiesType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JvmReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    public static final String XSD_PATH = "xsd/jvm-report.xsd";
    public static Log logger = LogFactory.getLog(JvmReportExtension.class);
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;

    public JvmReportExtension() {
        this(null);
    }

    private JvmReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        SystemPropertiesType systemPropertiesType = new SystemPropertiesType();
        List<PropertyType> properties = systemPropertiesType.getProperty();
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            PropertyType propertyType = new PropertyType();
            propertyType.setName((String)String.class.cast(property.getKey()));
            propertyType.setValue((String)String.class.cast(property.getValue()));
            properties.add(propertyType);
        }
        Jvm jvm = new Jvm();
        jvm.setSystemProperties(systemPropertiesType);
        return jvm;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/jvm-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return Jvm.class;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

