/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployment.ear.ConnectorModule;
import org.ow2.util.ee.deploy.api.deployment.ear.EJBModule;
import org.ow2.util.ee.deploy.api.deployment.ear.IEARInfo;
import org.ow2.util.ee.deploy.api.deployment.ear.JavaModule;
import org.ow2.util.ee.deploy.api.deployment.ear.WebModule;
import org.ow2.util.ee.deploy.impl.deployable.AbsDeployable;
import org.ow2.util.ee.deploy.impl.deployable.CARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.LibDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.OSGiDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.RARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.UnknownDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.WARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.ConnectorModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.EARInfoImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.EJBModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.JavaModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.WebModuleImpl;
import org.ow2.util.ee.deploy.impl.helper.EarUnpackOpts;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARDeployableImpl
extends AbsDeployable<EARDeployable>
implements EARDeployable {
    private static final String APPLICATION_XML_ENTRY = "META-INF/application.xml";
    private static final String BUNDLE_DIRECTORY = "bundle";
    private Log logger = LogFactory.getLog(EARDeployableImpl.class);
    private EARInfoImpl earInfo = null;
    private List<IDeployable<?>> allDeployables = null;
    private List<EJB21Deployable> ejb21Deployables = null;
    private List<EJB3Deployable> ejb3Deployables = null;
    private List<WARDeployable> warDeployables = null;
    private List<RARDeployable> rarDeployables = null;
    private List<CARDeployable> carDeployables = null;
    private List<LibDeployable> libDeployables = null;
    private List<OSGiDeployable> bundleDeployables = null;
    private List<String> classpathLibraries = null;
    private Map<URI, IDeployable<?>> mapUrl = new HashMap();

    public EARDeployableImpl(IArchive archive) {
        super(archive);
        this.allDeployables = new LinkedList();
        this.ejb21Deployables = new LinkedList<EJB21Deployable>();
        this.ejb3Deployables = new LinkedList<EJB3Deployable>();
        this.warDeployables = new LinkedList<WARDeployable>();
        this.rarDeployables = new LinkedList<RARDeployable>();
        this.carDeployables = new LinkedList<CARDeployable>();
        this.libDeployables = new LinkedList<LibDeployable>();
        this.bundleDeployables = new LinkedList<OSGiDeployable>();
        this.classpathLibraries = new LinkedList<String>();
        this.analyzeDD();
    }

    private void analyzeDD() {
        URL applicationXMLURL = null;
        try {
            applicationXMLURL = this.getArchive().getResource(APPLICATION_XML_ENTRY);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get entry 'META-INF/application.xml' on the archive '" + this.getArchive().getName() + "'.", e);
        }
        if (applicationXMLURL == null) {
            return;
        }
        this.earInfo = new EARInfoImpl();
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)applicationXMLURL, (boolean)false, null);
        }
        catch (DocumentParserException e) {
            throw new IllegalStateException("Cannot parse the url", e);
        }
        Element applicationRootElement = document.getDocumentElement();
        NodeList libraryDirectoryList = applicationRootElement.getElementsByTagName("library-directory");
        if (libraryDirectoryList.getLength() > 0) {
            Element libraryDirectoryElement = (Element)libraryDirectoryList.item(0);
            String nodeValue = "";
            Node txtNode = libraryDirectoryElement.getFirstChild();
            if (txtNode != null) {
                nodeValue = txtNode.getNodeValue().trim();
            }
            this.earInfo.setLibraryDirectory(nodeValue);
        }
        NodeList moduleList = applicationRootElement.getElementsByTagName("module");
        for (int i = 0; i < moduleList.getLength(); ++i) {
            Element moduleElement = (Element)moduleList.item(i);
            NodeList connectorList = moduleElement.getElementsByTagName("connector");
            NodeList altDDconnList = moduleElement.getElementsByTagName("alt-dd");
            for (int j = 0; j < connectorList.getLength(); ++j) {
                Node connNode = connectorList.item(j).getFirstChild();
                ConnectorModuleImpl connectorModule = new ConnectorModuleImpl();
                connectorModule.setPath(connNode.getNodeValue().trim());
                if (altDDconnList.getLength() > 0) {
                    Element altddElement = (Element)altDDconnList.item(0);
                    connectorModule.setAltDd(altddElement.getFirstChild().getNodeValue().trim());
                }
                this.earInfo.addConnectorModule(connectorModule);
            }
            NodeList ejbList = moduleElement.getElementsByTagName("ejb");
            NodeList altDDejbList = moduleElement.getElementsByTagName("alt-dd");
            for (int j = 0; j < ejbList.getLength(); ++j) {
                Node ejbNode = ejbList.item(j).getFirstChild();
                EJBModuleImpl ejbModule = new EJBModuleImpl();
                ejbModule.setPath(ejbNode.getNodeValue().trim());
                if (altDDejbList.getLength() > 0) {
                    Element altddElement = (Element)altDDejbList.item(0);
                    ejbModule.setAltDd(altddElement.getFirstChild().getNodeValue().trim());
                }
                this.earInfo.addEJBModule(ejbModule);
            }
            NodeList javaList = moduleElement.getElementsByTagName("java");
            NodeList altDDjavaList = moduleElement.getElementsByTagName("alt-dd");
            for (int j = 0; j < javaList.getLength(); ++j) {
                Node javaNode = javaList.item(j).getFirstChild();
                JavaModuleImpl javaModule = new JavaModuleImpl();
                javaModule.setPath(javaNode.getNodeValue().trim());
                if (altDDjavaList.getLength() > 0) {
                    Element altddElement = (Element)altDDejbList.item(0);
                    javaModule.setAltDd(altddElement.getFirstChild().getNodeValue().trim());
                }
                this.earInfo.addJavaModule(javaModule);
            }
            NodeList webList = moduleElement.getElementsByTagName("web");
            NodeList altDDwebList = moduleElement.getElementsByTagName("alt-dd");
            for (int j = 0; j < webList.getLength(); ++j) {
                Element webElement = (Element)webList.item(j);
                String path = webElement.getElementsByTagName("web-uri").item(0).getFirstChild().getNodeValue().trim();
                String contextRoot = webElement.getElementsByTagName("context-root").item(0).getFirstChild().getNodeValue().trim();
                if (contextRoot.startsWith("/") && !contextRoot.equals("/")) {
                    this.logger.debug((Object)"Context-Root ''{0}'' for module ''{1}'' contains invalid starting / in the name. Fixing it.", new Object[]{contextRoot, path});
                    int c = 0;
                    while (contextRoot.charAt(c) == '/') {
                        ++c;
                    }
                    contextRoot = contextRoot.substring(c);
                }
                WebModuleImpl webModule = new WebModuleImpl();
                webModule.setPath(path);
                webModule.setContextRoot(contextRoot);
                if (altDDwebList.getLength() > 0) {
                    Element altddElement = (Element)altDDejbList.item(0);
                    webModule.setAltDd(altddElement.getFirstChild().getNodeValue().trim());
                }
                this.earInfo.addWebModule(webModule);
            }
        }
    }

    @Override
    public List<EJBDeployable<?>> getEJBDeployables() {
        LinkedList ejbDeployables = new LinkedList();
        for (EJB21Deployable eJB21Deployable : this.ejb21Deployables) {
            ejbDeployables.add(eJB21Deployable);
        }
        for (EJB3Deployable eJB3Deployable : this.ejb3Deployables) {
            ejbDeployables.add(eJB3Deployable);
        }
        return ejbDeployables;
    }

    @Override
    public List<EJB21Deployable> getEJB21Deployables() {
        return this.ejb21Deployables;
    }

    @Override
    public List<EJB3Deployable> getEJB3Deployables() {
        return this.ejb3Deployables;
    }

    @Override
    public List<WARDeployable> getWARDeployables() {
        return this.warDeployables;
    }

    @Override
    public List<RARDeployable> getRARDeployables() {
        return this.rarDeployables;
    }

    @Override
    public List<CARDeployable> getCARDeployables() {
        return this.carDeployables;
    }

    @Override
    public List<LibDeployable> getLibDeployables() {
        return this.libDeployables;
    }

    public List<OSGiDeployable> getOSGiDeployables() {
        return this.bundleDeployables;
    }

    public void addDeployable(IDeployable<?> deployable) {
        this.addDeployable(deployable, null);
    }

    public void addDeployable(IDeployable<?> deployable, EarUnpackOpts earUnpackOpts) {
        IDeployable<?> modifiedDeployable = this.changeTypeIfSpecified(deployable);
        modifiedDeployable = this.checkLibDeployable(modifiedDeployable);
        modifiedDeployable = this.updateDeployableIfBundle(modifiedDeployable);
        this.analyzeClassPathModules(modifiedDeployable);
        this.allDeployables.add(modifiedDeployable);
        if (EJB21Deployable.class.isInstance(modifiedDeployable)) {
            this.ejb21Deployables.add((EJB21Deployable)EJB21Deployable.class.cast(modifiedDeployable));
        } else if (EJB3Deployable.class.isInstance(modifiedDeployable)) {
            this.ejb3Deployables.add((EJB3Deployable)EJB3Deployable.class.cast(modifiedDeployable));
        } else if (WARDeployable.class.isInstance(modifiedDeployable)) {
            WARDeployable warDeployable = (WARDeployable)WARDeployable.class.cast(modifiedDeployable);
            if (earUnpackOpts != null && earUnpackOpts.isWarAutoUnpacked()) {
                try {
                    File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + "EE-Deployer" + "-" + System.getProperty("user.name", "default") + File.separator + this.getShortName());
                    rootFolder.mkdirs();
                    warDeployable = UnpackDeployableHelper.unpack(warDeployable, rootFolder, warDeployable.getShortName());
                }
                catch (DeployerException e) {
                    this.logger.error((Object)"Unable to unpack a war", new Object[]{e});
                }
            }
            this.warDeployables.add(warDeployable);
            this.setContextRoot(warDeployable);
        } else if (RARDeployable.class.isInstance(modifiedDeployable)) {
            this.rarDeployables.add((RARDeployable)RARDeployable.class.cast(modifiedDeployable));
        } else if (CARDeployable.class.isInstance(modifiedDeployable)) {
            this.carDeployables.add((CARDeployable)CARDeployable.class.cast(modifiedDeployable));
        } else if (LibDeployable.class.isInstance(modifiedDeployable)) {
            this.libDeployables.add((LibDeployable)LibDeployable.class.cast(modifiedDeployable));
        } else if (OSGiDeployable.class.isInstance(modifiedDeployable)) {
            this.bundleDeployables.add((OSGiDeployable)OSGiDeployable.class.cast(modifiedDeployable));
        } else if (UnknownDeployable.class.isInstance(modifiedDeployable)) {
            this.logger.debug((Object)"Found an unknown deployable {0}", new Object[]{modifiedDeployable});
        } else {
            throw new IllegalStateException("The EAR deployable archive doesn't support the include of archive with '" + modifiedDeployable.getClass() + "' class object, deployable ='" + modifiedDeployable + "'.");
        }
        try {
            URL urldeployable = modifiedDeployable.getArchive().getURL();
            this.mapUrl.put(urldeployable.toURI(), modifiedDeployable);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get URL of the deployable ", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot get URL of the deployable ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void analyzeClassPathModules(IDeployable<?> deployable) {
        urlManifest = null;
        try {
            urlManifest = deployable.getArchive().getResource("META-INF/MANIFEST.MF");
        }
        catch (ArchiveException e) {
            this.logger.error((Object)"Unable to read the MANIFEST in the deployable {0}", new Object[]{deployable, e});
        }
        if (urlManifest == null) {
            this.logger.debug((Object)"No MANIFEST found in the deployable {0}", new Object[]{deployable});
            return;
        }
        manifest = new Manifest();
        urlConnection = null;
        try {
            urlConnection = urlManifest.openConnection();
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to open connection on URL {0}", new Object[]{urlManifest, e});
            return;
        }
        urlConnection.setUseCaches(false);
        is = null;
        try {
            is = urlConnection.getInputStream();
            manifest.read(is);
            ** if (is == null) goto lbl-1000
        }
        catch (IOException e) {
            block19: {
                try {
                    this.logger.error((Object)"Unable to read stream of {0}", new Object[]{urlManifest, e});
                    if (is == null) break block19;
                }
                catch (Throwable var8_13) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            this.logger.error((Object)"Unable to close stream of {0}", new Object[]{urlManifest, e});
                            return;
                        }
                    }
                    throw var8_13;
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close stream of {0}", new Object[]{urlManifest, e});
                    return;
                }
            }
            return;
        }
lbl-1000:
        // 1 sources

        {
            try {
                is.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Unable to close stream of {0}", new Object[]{urlManifest, e});
                return;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
        if ((classPath = (attributes = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            stringTokenizer = new StringTokenizer(classPath);
            while (stringTokenizer.hasMoreTokens()) {
                module = stringTokenizer.nextToken();
                relativeName = this.getRelativeNameOfAModuleFromDeployable(deployable, module);
                if (relativeName == null || this.classpathLibraries.contains(relativeName)) continue;
                this.classpathLibraries.add(relativeName);
            }
        }
    }

    protected IDeployable<?> changeTypeIfSpecified(IDeployable<?> deployable) {
        if (this.earInfo == null) {
            return deployable;
        }
        String relativeModuleName = this.getRelativeNameFromDeployable(deployable);
        for (EJBModule ejbModule : this.earInfo.getEJBs()) {
            if (!relativeModuleName.equals(ejbModule.getPath())) continue;
            if (EJBDeployable.class.isInstance(deployable)) {
                return deployable;
            }
            throw new IllegalArgumentException("The given deployable '" + deployable + "' is not an EJB but it is flagged as an EJB-JAR in the application.xml file");
        }
        for (WebModule webModule : this.earInfo.getWebs()) {
            if (!relativeModuleName.equals(webModule.getPath())) continue;
            return new WARDeployableImpl(deployable.getArchive());
        }
        for (ConnectorModule connectorModule : this.earInfo.getConnectors()) {
            if (!relativeModuleName.equals(connectorModule.getPath())) continue;
            return new RARDeployableImpl(deployable.getArchive());
        }
        for (JavaModule javaModule : this.earInfo.getClients()) {
            if (!relativeModuleName.equals(javaModule.getPath())) continue;
            return new CARDeployableImpl(deployable.getArchive());
        }
        return new UnknownDeployableImpl(deployable.getArchive());
    }

    protected IDeployable<?> checkLibDeployable(IDeployable<?> deployable) {
        String relativeModuleName = this.getRelativeNameFromDeployable(deployable);
        String libraryDirectory = null;
        libraryDirectory = this.earInfo != null ? this.earInfo.getLibraryDirectory() : "lib";
        if ("".equals(libraryDirectory)) {
            return deployable;
        }
        if (!libraryDirectory.endsWith("/")) {
            libraryDirectory = libraryDirectory + "/";
        }
        if (relativeModuleName.startsWith(libraryDirectory)) {
            return new LibDeployableImpl(deployable.getArchive());
        }
        return deployable;
    }

    protected IDeployable<?> updateDeployableIfBundle(IDeployable<?> deployable) {
        String relativeModuleName = this.getRelativeNameFromDeployable(deployable);
        String bundleDirectory = BUNDLE_DIRECTORY;
        if ("".equals(bundleDirectory)) {
            return deployable;
        }
        if (!bundleDirectory.endsWith("/")) {
            bundleDirectory = bundleDirectory + "/";
        }
        if (relativeModuleName.startsWith(bundleDirectory)) {
            return new OSGiDeployableImpl(deployable.getArchive());
        }
        return deployable;
    }

    protected String getRelativeNameFromDeployable(IDeployable<?> deployable) {
        URL earURL = null;
        try {
            earURL = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the EAR file '" + this + "'.", e);
        }
        URL deployableURL = null;
        try {
            Object originalDeployable = deployable.getOriginalDeployable();
            deployableURL = originalDeployable != null ? originalDeployable.getArchive().getURL() : deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the deployable '" + deployable + "'.", e);
        }
        String relativeName = deployableURL.toExternalForm().substring(earURL.toExternalForm().length());
        if (relativeName.endsWith("/")) {
            relativeName = relativeName.substring(0, relativeName.length() - 1);
        }
        return relativeName;
    }

    protected String computePathForModule(IDeployable<?> deployable, String relativeName, boolean relative) {
        URL earURL = null;
        try {
            earURL = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the EAR file '" + this + "'.", e);
        }
        URL deployableURL = null;
        try {
            deployableURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the deployable '" + deployable + "'.", e);
        }
        String newName = deployableURL.getPath() + "/../" + relativeName;
        URI uriTmp = null;
        try {
            uriTmp = new URI(deployableURL.getProtocol() + ":" + newName);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot build URI", e);
        }
        uriTmp = uriTmp.normalize();
        if (relative) {
            try {
                if (!uriTmp.toString().startsWith(earURL.toURI().toString())) {
                    this.logger.warn((Object)"The deployable ''{0}'' is referencing through the Class-Path: entry ''{1}'' but this module is not inside the EAR. Ignore it", new Object[]{deployable, relativeName});
                    return null;
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot normalize URI", e);
            }
            try {
                return uriTmp.toString().substring(earURL.toURI().toString().length());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot normalize URI", e);
            }
        }
        return uriTmp.toString();
    }

    protected String getRelativeNameOfAModuleFromDeployable(IDeployable<?> deployable, String relativeName) {
        return this.computePathForModule(deployable, relativeName, true);
    }

    protected void setContextRoot(WARDeployable warDeployable) {
        String relativeWarFileName = this.getRelativeNameFromDeployable(warDeployable);
        boolean found = false;
        if (this.earInfo != null) {
            for (WebModule webModule : this.earInfo.getWebs()) {
                if (!relativeWarFileName.equals(webModule.getPath())) continue;
                String ctxRoot = webModule.getContextRoot();
                warDeployable.setContextRoot(ctxRoot);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Context root for War deployable ''{0}'' was found in the EAR {1} file, the value is ''{2}''", new Object[]{warDeployable, APPLICATION_XML_ENTRY, ctxRoot});
                }
                found = true;
                break;
            }
        }
        if (!found) {
            String ctxRoot = warDeployable.getModuleName();
            warDeployable.setContextRoot(ctxRoot);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The entry for War deployable ''{0}'' was not found in the EAR application.xml file, using a default context-root value ''{1}''", new Object[]{warDeployable, ctxRoot});
            }
        }
    }

    public void resolveClassPath() {
        if (this.classpathLibraries.isEmpty()) {
            return;
        }
        LinkedList currentDeployables = new LinkedList();
        for (IDeployable<?> iDeployable : this.allDeployables) {
            currentDeployables.add(iDeployable);
        }
        for (IDeployable<Object> iDeployable : currentDeployables) {
            String relativeFileName = this.getRelativeNameFromDeployable(iDeployable);
            if (!this.classpathLibraries.contains(relativeFileName)) continue;
            if (!UnknownDeployable.class.isInstance(iDeployable) && !LibDeployable.class.isInstance(iDeployable)) {
                this.logger.warn((Object)"Deployable {0} is marked as LibraryDeployable in MANIFEST Class-Path: entry but this is a Java EE module.", new Object[]{iDeployable});
            }
            if (LibDeployable.class.isInstance(iDeployable)) continue;
            this.allDeployables.remove(iDeployable);
            LibDeployableImpl libDeployable = new LibDeployableImpl(iDeployable.getArchive());
            this.libDeployables.add(libDeployable);
            this.allDeployables.add(libDeployable);
        }
    }

    protected String getPathOfArelativeModuleFromDeployable(IDeployable<?> deployable, String relativeName) {
        return this.computePathForModule(deployable, relativeName, false);
    }

    @Override
    public IEARInfo getEARInfo() {
        return this.earInfo;
    }

    @Override
    public List<IDeployable<?>> getAllDeployables() {
        return this.allDeployables;
    }

    @Override
    public IDeployable<?> getDeployable(URL url) {
        IDeployable<?> deployable = null;
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        if (this.mapUrl.containsKey(uri)) {
            deployable = this.mapUrl.get(uri);
        }
        return deployable;
    }

    @Override
    public URL getAltDDURL(IDeployable<?> deployable) {
        if (this.earInfo == null) {
            return null;
        }
        String relativeModuleName = this.getRelativeNameFromDeployable(deployable);
        String path = null;
        for (EJBModule ejbModule : this.earInfo.getEJBs()) {
            path = ejbModule.getAltDd();
            if (path == null || !relativeModuleName.equals(ejbModule.getPath())) continue;
            path = this.getPathOfArelativeModuleFromDeployable(deployable, ejbModule.getAltDd());
            return this.stringToURL(path);
        }
        for (WebModule webModule : this.earInfo.getWebs()) {
            path = webModule.getAltDd();
            if (path == null || !relativeModuleName.equals(webModule.getPath())) continue;
            path = this.getPathOfArelativeModuleFromDeployable(deployable, webModule.getAltDd());
            return this.stringToURL(path);
        }
        for (ConnectorModule connectorModule : this.earInfo.getConnectors()) {
            path = connectorModule.getAltDd();
            if (path == null || !relativeModuleName.equals(connectorModule.getPath())) continue;
            path = this.getPathOfArelativeModuleFromDeployable(deployable, connectorModule.getAltDd());
            return this.stringToURL(path);
        }
        for (JavaModule javaModule : this.earInfo.getClients()) {
            path = javaModule.getAltDd();
            if (path == null || !relativeModuleName.equals(javaModule.getPath())) continue;
            path = this.getPathOfArelativeModuleFromDeployable(deployable, javaModule.getAltDd());
            return this.stringToURL(path);
        }
        return null;
    }

    private URL stringToURL(String path) {
        URL url = null;
        try {
            url = new URL(path);
            return url;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid path '" + path + "'.", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EAR '");
        sb.append(this.getShortName());
        sb.append("', application.xml ");
        if (this.earInfo != null) {
            sb.append(" provided");
        } else {
            sb.append(" N/A");
        }
        sb.append(", Content: ");
        sb.append(this.getDeployablesInfo("EJB-JAR(s)", this.getEJBDeployables()));
        sb.append(this.getDeployablesInfo("WAR(s)", this.getWARDeployables()));
        sb.append(this.getDeployablesInfo("RAR(s)", this.getRARDeployables()));
        sb.append(this.getDeployablesInfo("Libraries", this.getLibDeployables()));
        sb.append(this.getDeployablesInfo("OSGi bundle(s)", this.getOSGiDeployables()));
        sb.append(this.getDeployablesInfo("CAR(s)", this.getCARDeployables()));
        return sb.toString();
    }

    private <T extends IDeployable<?>> String getDeployablesInfo(String title, List<T> deployables) {
        StringBuilder sb = new StringBuilder();
        if (deployables.size() == 0) {
            return "";
        }
        sb.append(", ");
        sb.append(deployables.size());
        sb.append(" ");
        sb.append(title);
        sb.append(" {");
        int i = 0;
        for (IDeployable deployable : deployables) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getRelativeNameFromDeployable(deployable));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

