/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.commands;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jonas.addon.commands.InspectCommand;
import org.ow2.jonas.addon.commands.ListAddonCommand;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonMetadata;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonService;
import org.ow2.jonas.properties.ServiceProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="info", scope="addon", description="show addon information")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class AddonInfoCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(AddonInfoCommand.class);
    private boolean __FaddonId;
    @Argument(name="addonId", required=true, description="Id of the Addon")
    private String addonId;
    private boolean __FaddonService;
    @Requires(optional=false)
    private IAddonService addonService;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    String __getaddonId() {
        if (!this.__FaddonId) {
            return this.addonId;
        }
        return (String)this.__IM.onGet((Object)this, "addonId");
    }

    void __setaddonId(String string) {
        if (!this.__FaddonId) {
            this.addonId = string;
            return;
        }
        this.__IM.onSet((Object)this, "addonId", (Object)string);
    }

    IAddonService __getaddonService() {
        if (!this.__FaddonService) {
            return this.addonService;
        }
        return (IAddonService)this.__IM.onGet((Object)this, "addonService");
    }

    void __setaddonService(IAddonService iAddonService) {
        if (!this.__FaddonService) {
            this.addonService = iAddonService;
            return;
        }
        this.__IM.onSet((Object)this, "addonService", (Object)iAddonService);
    }

    public AddonInfoCommand() {
        this(null);
    }

    private AddonInfoCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Long id = null;
        try {
            id = Long.parseLong(this.__getaddonId());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Invalid addon id " + this.__getaddonId()), new Object[]{e});
        }
        IAddonDeployable addon = this.__getaddonService().getAddon(id.longValue());
        if (addon != null) {
            ServiceProperties serviceProperties;
            String instance;
            String tenantId;
            stringBuilder.append(addon.getName());
            stringBuilder.append(" (ID ");
            stringBuilder.append(addon.getAddonId());
            stringBuilder.append(")");
            stringBuilder.append("\n");
            int length = addon.getName().length();
            length = length + 5 + String.valueOf(addon.getAddonId()).length();
            for (int i = 0; i < length; ++i) {
                stringBuilder.append("-");
            }
            stringBuilder.append(":");
            stringBuilder.append("\n");
            stringBuilder.append("parent.id = ");
            IAddonDeployable parent = addon.getParent();
            if (parent != null) {
                stringBuilder.append(parent.getAddonId());
            } else {
                stringBuilder.append("none");
            }
            stringBuilder.append("\n");
            stringBuilder.append("state = ");
            stringBuilder.append(ListAddonCommand.getStateAsString(addon.getState()));
            stringBuilder.append("\n");
            stringBuilder.append("capabilities = ");
            stringBuilder.append(InspectCommand.printList(addon.getCapabilities()));
            stringBuilder.append("\n");
            stringBuilder.append("requirements = ");
            stringBuilder.append(InspectCommand.printList(addon.getRequirements()));
            stringBuilder.append("\n");
            stringBuilder.append("configuration.directory = ");
            File configurationDirectory = addon.getConfigurationDirectory();
            if (configurationDirectory != null && configurationDirectory.exists()) {
                stringBuilder.append(configurationDirectory.getAbsolutePath());
            }
            stringBuilder.append("\n");
            stringBuilder.append("configuration.files = ");
            stringBuilder.append(InspectCommand.printList(addon.getConfigurationFileNames()));
            IAddonMetadata metadata = addon.getMetadata();
            stringBuilder.append("\n");
            stringBuilder.append("jonas.service = ");
            stringBuilder.append(String.valueOf(metadata.isJOnASService()));
            stringBuilder.append("\n");
            if (metadata.isJOnASService()) {
                stringBuilder.append("jonas.service.name = ");
                stringBuilder.append(metadata.getService());
                stringBuilder.append("\n");
            }
            stringBuilder.append("metadata.autostart = ");
            stringBuilder.append(String.valueOf(metadata.getAutostart()));
            stringBuilder.append("\n");
            stringBuilder.append("metadata.author = ");
            stringBuilder.append(metadata.getAuthor());
            stringBuilder.append("\n");
            stringBuilder.append("metadata.licence = ");
            stringBuilder.append(metadata.getLicence());
            String description = metadata.getDescription();
            if (description != null && !description.isEmpty()) {
                stringBuilder.append("\n");
                stringBuilder.append("metadata.description = ");
                stringBuilder.append(metadata.getDescription());
            }
            if ((tenantId = metadata.getTenantId()) != null && !tenantId.isEmpty()) {
                stringBuilder.append("\n");
                stringBuilder.append("metadata.tenantId = ");
                stringBuilder.append(tenantId);
            }
            if ((instance = metadata.getInstance()) != null && !instance.isEmpty()) {
                stringBuilder.append("\n");
                stringBuilder.append("metadata.instance = ");
                stringBuilder.append(instance);
            }
            if ((serviceProperties = metadata.getServiceProperties()) != null) {
                stringBuilder.append("\n");
                stringBuilder.append("metadata.properties = ");
                Properties properties = serviceProperties.getProperties();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    stringBuilder.append("\n");
                    stringBuilder.append("  ");
                    stringBuilder.append(key);
                    stringBuilder.append(" = ");
                    stringBuilder.append(value);
                }
            }
        } else {
            logger.error((Object)("Unable to cache addon: " + id), new Object[0]);
        }
        return stringBuilder.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("addonId")) {
                this.__FaddonId = true;
            }
            if (set.contains("addonService")) {
                this.__FaddonService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

