/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.commands;

import java.io.File;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonService;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="install", scope="addon", description="install an addon")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class InstallAddonCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(InstallAddonCommand.class);
    private boolean __FaddonService;
    @Requires(optional=false)
    private IAddonService addonService;
    private boolean __FdeployableHelper;
    @Requires(optional=false)
    private IDeployableHelper deployableHelper;
    private boolean __Fpath;
    @Argument(name="path", required=true, description="The path to the file to install")
    private String path;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    IAddonService __getaddonService() {
        if (!this.__FaddonService) {
            return this.addonService;
        }
        return (IAddonService)this.__IM.onGet((Object)this, "addonService");
    }

    void __setaddonService(IAddonService iAddonService) {
        if (!this.__FaddonService) {
            this.addonService = iAddonService;
            return;
        }
        this.__IM.onSet((Object)this, "addonService", (Object)iAddonService);
    }

    IDeployableHelper __getdeployableHelper() {
        if (!this.__FdeployableHelper) {
            return this.deployableHelper;
        }
        return (IDeployableHelper)this.__IM.onGet((Object)this, "deployableHelper");
    }

    void __setdeployableHelper(IDeployableHelper iDeployableHelper) {
        if (!this.__FdeployableHelper) {
            this.deployableHelper = iDeployableHelper;
            return;
        }
        this.__IM.onSet((Object)this, "deployableHelper", (Object)iDeployableHelper);
    }

    String __getpath() {
        if (!this.__Fpath) {
            return this.path;
        }
        return (String)this.__IM.onGet((Object)this, "path");
    }

    void __setpath(String string) {
        if (!this.__Fpath) {
            this.path = string;
            return;
        }
        this.__IM.onSet((Object)this, "path", (Object)string);
    }

    public InstallAddonCommand() {
        this(null);
    }

    private InstallAddonCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdeployableHelper(null);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) {
        IAddonDeployable addon = null;
        File file = new File(this.__getpath());
        if (file.exists()) {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            try {
                IDeployable deployable = this.__getdeployableHelper().getDeployable(archive);
                if (IAddonDeployable.class.isInstance(deployable)) {
                    addon = (IAddonDeployable)IAddonDeployable.class.cast(deployable);
                } else {
                    logger.error((Object)("The deployable " + deployable.getShortName() + " is not an Addon deployable. It won't be deploy."), new Object[0]);
                }
            }
            catch (DeployableHelperException e) {
                logger.error((Object)"Could get the Deployable object for the given URL.", new Object[0]);
            }
            if (addon != null) {
                try {
                    this.__getaddonService().install((IDeployable)addon, true);
                }
                catch (DeployerException e) {
                    logger.error((Object)("The addon " + addon.getShortName() + " could not be installed."), new Object[]{e});
                }
            }
        } else {
            logger.error((Object)("The file " + file + " doesn't exist"), new Object[0]);
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("addonService")) {
                this.__FaddonService = true;
            }
            if (set.contains("deployableHelper")) {
                this.__FdeployableHelper = true;
            }
            if (set.contains("path")) {
                this.__Fpath = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

