/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonService;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="stop", scope="addon", description="stop addons")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class StopAddonCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(StopAddonCommand.class);
    private boolean __FaddonService;
    @Requires(optional=false)
    private IAddonService addonService;
    private boolean __FaddonIdList;
    @Argument(name="addonIdList", required=true, description="Id of the Addon to stop", multiValued=true)
    private List<String> addonIdList;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    IAddonService __getaddonService() {
        if (!this.__FaddonService) {
            return this.addonService;
        }
        return (IAddonService)this.__IM.onGet((Object)this, "addonService");
    }

    void __setaddonService(IAddonService iAddonService) {
        if (!this.__FaddonService) {
            this.addonService = iAddonService;
            return;
        }
        this.__IM.onSet((Object)this, "addonService", (Object)iAddonService);
    }

    List __getaddonIdList() {
        if (!this.__FaddonIdList) {
            return this.addonIdList;
        }
        return (List)this.__IM.onGet((Object)this, "addonIdList");
    }

    void __setaddonIdList(List list) {
        if (!this.__FaddonIdList) {
            this.addonIdList = list;
            return;
        }
        this.__IM.onSet((Object)this, "addonIdList", (Object)list);
    }

    public StopAddonCommand() {
        this(null);
    }

    private StopAddonCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) {
        ArrayList<IAddonDeployable> addons = new ArrayList<IAddonDeployable>();
        if (this.__getaddonIdList() != null) {
            for (String addonId : this.__getaddonIdList()) {
                Long id = null;
                try {
                    id = Long.parseLong(addonId);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("Invalid addon id " + addonId), new Object[]{e});
                }
                IAddonDeployable addon = this.__getaddonService().getAddon(id.longValue());
                if (addon != null) {
                    addons.add(addon);
                    continue;
                }
                logger.error((Object)("Unable to cache addon: " + id), new Object[0]);
            }
            for (IAddonDeployable addon : addons) {
                try {
                    this.__getaddonService().stop(addon.getMetadata().getName());
                }
                catch (DeployerException e) {
                    logger.error((Object)("The addon " + addon.getMetadata().getName() + " could not be stopped."), new Object[]{e});
                }
            }
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("addonIdList")) {
                this.__FaddonIdList = true;
            }
            if (set.contains("addonService")) {
                this.__FaddonService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

