/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web.xml;

import org.ow2.jonas.deployment.common.CommonsSchemas;
import org.ow2.jonas.deployment.common.xml.AbsJonasEnvironmentElement;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.common.xml.JonasSecurity;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;
import org.ow2.jonas.deployment.web.JonasWebAppSchemas;
import org.ow2.jonas.deployment.web.xml.JonasServlet;

public class JonasWebApp
extends AbsJonasEnvironmentElement
implements TopLevelElement {
    private String header = null;
    private String host = null;
    private String contextRoot = null;
    private String port = null;
    private String java2DelegationModel = null;
    private JLinkedList jonasMessageDestinationList = new JLinkedList("jonas-message-destination");
    private JLinkedList servletList = new JLinkedList("servlet");
    private JonasSecurity jonasSecurity = null;
    public static final String JONAS_WEBAPP_ELEMENT = CommonsSchemas.getHeaderForElement("jonas-web-app", JonasWebAppSchemas.getLastSchema());

    public JonasWebApp() {
        this.header = JONAS_WEBAPP_ELEMENT;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setJava2DelegationModel(String java2DelegationModel) {
        this.java2DelegationModel = java2DelegationModel;
    }

    public void setJonasMessageDestinationList(JLinkedList jonasMessageDestinationList) {
        this.jonasMessageDestinationList = jonasMessageDestinationList;
    }

    public void setServletList(JLinkedList servletList) {
        this.servletList = servletList;
    }

    public void addJonasMessageDestination(JonasMessageDestination jonasMessageDestination) {
        this.jonasMessageDestinationList.add(jonasMessageDestination);
    }

    public void addServlet(JonasServlet jonasServlet) {
        this.servletList.add(jonasServlet);
    }

    public String getHost() {
        return this.host;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getPort() {
        return this.port;
    }

    public String getJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    public JLinkedList getJonasMessageDestinationList() {
        return this.jonasMessageDestinationList;
    }

    public JLinkedList getServletList() {
        return this.servletList;
    }

    @Override
    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        if (this.header != null) {
            sb.append(this.header);
        } else {
            sb.append("<jonas-web-app>\n");
        }
        sb.append(this.getJonasResourceEnvList().toXML(indent += 2));
        sb.append(this.getJonasResourceList().toXML(indent));
        sb.append(this.getJonasEjbRefList().toXML(indent));
        sb.append(this.getJonasMessageDestinationRefList().toXML(indent));
        sb.append(this.getJonasMessageDestinationList().toXML(indent));
        sb.append(this.getJonasServiceRefList().toXML(indent));
        sb.append(this.getServletList().toXML(indent));
        sb.append(this.xmlElement(this.getTenantId(), "tenant-id", indent));
        if (this.host != null) {
            sb.append(this.xmlElement(this.host, "host", indent));
        }
        if (this.contextRoot != null) {
            sb.append(this.xmlElement(this.contextRoot, "context-root", indent));
        }
        if (this.port != null) {
            sb.append(this.xmlElement(this.port, "port", indent));
        }
        if (this.java2DelegationModel != null) {
            sb.append(this.xmlElement(this.java2DelegationModel, "java2-delegation-model", indent));
        }
        if (this.jonasSecurity != null) {
            sb.append(this.jonasSecurity.toXML(indent));
        }
        sb.append(this.indent(indent -= 2));
        sb.append("</jonas-web-app>");
        return sb.toString();
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public JonasSecurity getJonasSecurity() {
        return this.jonasSecurity;
    }

    public void setJonasSecurity(JonasSecurity jonasSecurity) {
        this.jonasSecurity = jonasSecurity;
    }
}

