/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.ow2.jonas.lib.jmbeans.log.LogBuffer;

public class LogNotificationListener
implements NotificationListener {
    private LogBuffer logBuffer = null;

    public LogNotificationListener(LogBuffer buf) {
        this.logBuffer = buf;
    }

    @Override
    public void handleNotification(Notification nf, Object handback) {
        LogRecord record = null;
        if (!(nf.getUserData() instanceof LogRecord)) {
            return;
        }
        record = (LogRecord)nf.getUserData();
        this.logBuffer.incRecordCount();
        if (this.logBuffer.getOldestDate() == 0L) {
            this.logBuffer.setOldestDate(record.getMillis());
        }
        int level = record.getLevel().intValue();
        if (Level.INFO.intValue() == level) {
            this.logBuffer.incInfoCount();
        } else if (Level.WARNING.intValue() == level) {
            this.logBuffer.incWarningCount();
        } else if (Level.SEVERE.intValue() == level) {
            this.logBuffer.incSevereCount();
        } else {
            this.logBuffer.incOtherCount();
        }
        this.logBuffer.setLatestDate(record.getMillis());
        this.logBuffer.addToRecentLog(record);
        this.logBuffer.addToLogRecordsQueue(record);
    }
}

