/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployable;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonMetadata;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.impl.deployable.AbsDeployable;

public class AddonDeployableImpl
extends AbsDeployable<IAddonDeployable>
implements IAddonDeployable {
    private List<ISortableDeployable> deployables = new ArrayList<ISortableDeployable>();
    private IAddonMetadata addonMetadata;
    private int state = 1;
    private Long addonId;
    private List<String> capabilities = new ArrayList<String>();
    private IAddonDeployable parent;
    private File configurationDirectory;
    private List<String> configurationFileNames = new ArrayList<String>();

    public AddonDeployableImpl(IArchive archive) {
        super(archive);
    }

    public void addDeployable(ISortableDeployable sortableDeployable) {
        this.deployables.add(sortableDeployable);
    }

    public void removeDeployable(ISortableDeployable sortableDeployable) {
        this.deployables.remove(sortableDeployable);
    }

    public String getName() {
        if (this.addonMetadata != null) {
            return this.addonMetadata.getName();
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public synchronized void updateState(int state) {
        this.state = state;
        if (32 == this.state) {
            List capabilities;
            if (!this.capabilities.isEmpty()) {
                this.capabilities.clear();
            }
            if (this.addonMetadata != null && (capabilities = this.addonMetadata.getProvides()) != null && !capabilities.isEmpty()) {
                for (String capability : capabilities) {
                    if (capability.isEmpty()) continue;
                    this.capabilities.add(capability);
                }
            }
        } else if (!this.capabilities.isEmpty()) {
            this.capabilities.clear();
        }
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getRequirements() {
        if (this.addonMetadata != null) {
            return this.addonMetadata.getRequirements();
        }
        return null;
    }

    public Long getAddonId() {
        return this.addonId;
    }

    public void setAddonId(Long addonId) {
        if (this.addonId == null && addonId != null) {
            this.addonId = addonId;
        }
    }

    public List<ISortableDeployable> getKnownDeployables() {
        ArrayList<ISortableDeployable> knownDeployables = new ArrayList<ISortableDeployable>();
        for (ISortableDeployable sortableDeployable : this.deployables) {
            if (UnknownDeployable.class.isInstance(sortableDeployable.getDeployable())) continue;
            knownDeployables.add(sortableDeployable);
        }
        return knownDeployables;
    }

    public List<ISortableDeployable> getUnknownDeployables() {
        ArrayList<ISortableDeployable> unknownDeployables = new ArrayList<ISortableDeployable>();
        for (ISortableDeployable sortableDeployable : this.deployables) {
            if (!UnknownDeployable.class.isInstance(sortableDeployable.getDeployable())) continue;
            unknownDeployables.add(sortableDeployable);
        }
        return unknownDeployables;
    }

    public IAddonMetadata getMetadata() {
        return this.addonMetadata;
    }

    public void setMetadata(IAddonMetadata addonMetadata) {
        this.addonMetadata = addonMetadata;
    }

    public IAddonDeployable getParent() {
        return this.parent;
    }

    public File getConfigurationDirectory() {
        return this.configurationDirectory;
    }

    public List<String> getConfigurationFileNames() {
        return this.configurationFileNames;
    }

    public void setConfigurationDirectory(File configurationDirectory) {
        if (configurationDirectory != null && configurationDirectory.exists()) {
            this.configurationDirectory = configurationDirectory;
            this.configurationFileNames.clear();
            File[] files = this.configurationDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.configurationFileNames.add(file.getName());
                }
            }
        }
    }

    public void setParent(IAddonDeployable parent) {
        this.parent = parent;
    }
}

