/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployable;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.utils.version.VersionRange;
import org.osgi.framework.Version;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonMetadata;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.addon.properties.ServicePropertiesImpl;
import org.ow2.jonas.properties.ServiceProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AddonMetaData
implements IAddonMetadata {
    private static Log logger = LogFactory.getLog(AddonMetaData.class);
    private String name;
    private String description;
    private String tenantId;
    private String instance;
    private String author;
    private String licence;
    private VersionRange jonasVersions;
    private Boolean autostart = false;
    private VersionRange jvmVersions;
    private List<String> provides = new ArrayList<String>();
    private List<String> requirements = new ArrayList<String>();
    private ServiceProperties serviceProperties;
    private File metaDataFile;
    private String service;
    private String implementation;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLicence() {
        return this.licence;
    }

    public boolean isJOnASVersionSupported(String jonasVersion) {
        try {
            return AddonMetaData.isVersionSupported(this.jonasVersions, AddonMetaData.convert(jonasVersion));
        }
        catch (Exception e) {
            logger.error((Object)("The given version '" + jonasVersion + "'is incorrect. Cannot convert it as a " + Version.class.getName() + " object."), new Object[]{e});
            return false;
        }
    }

    public Boolean getAutostart() {
        return this.autostart;
    }

    public boolean isJvmVersionSupported(String jvmVersion) {
        try {
            return AddonMetaData.isVersionSupported(this.jvmVersions, AddonMetaData.convert(jvmVersion));
        }
        catch (Exception e) {
            logger.error((Object)("The given version '" + jvmVersion + "'is incorrect. Cannot convert it as a " + Version.class.getName() + " object."), new Object[]{e});
            return false;
        }
    }

    public static boolean isVersionSupported(String versionRange, String version) throws Exception {
        return AddonMetaData.isVersionSupported(AddonMetaData.parse(versionRange), AddonMetaData.convert(version));
    }

    public static boolean isVersionSupported(VersionRange versionRange, Version version) {
        if (versionRange != null && version != null) {
            return versionRange.contains(version);
        }
        return false;
    }

    public List<String> getProvides() {
        return this.provides;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public File getMetaDataFile() {
        return this.metaDataFile;
    }

    public String getService() {
        return this.service;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public boolean isJOnASService() {
        return this.service != null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public void setJonasVersions(String jonasVersions) throws Exception {
        this.jonasVersions = AddonMetaData.parse(jonasVersions);
    }

    public void setAutostart(Boolean autostart) {
        this.autostart = autostart;
    }

    public void setJvmVersions(String jvmVersions) throws Exception {
        this.jvmVersions = AddonMetaData.parse(jvmVersions);
    }

    public void setProvides(String provides) {
        this.provides = AddonUtil.getTokens(provides, " ");
    }

    public void setRequirements(String requirements) {
        this.requirements = AddonUtil.getTokens(requirements, " ");
    }

    public void setServiceProperties(Properties properties) {
        this.serviceProperties = new ServicePropertiesImpl(properties, this.service);
    }

    public void setMetaDataFile(File metaDataFile) {
        this.metaDataFile = metaDataFile;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    private static VersionRange parse(String range) throws Exception {
        if (range.indexOf(44) >= 0) {
            String s = range.substring(1, range.length() - 1);
            String vlo = s.substring(0, s.indexOf(44)).trim();
            String vhi = s.substring(s.indexOf(44) + 1, s.length()).trim();
            return new VersionRange(range.charAt(0) == '[', AddonMetaData.convert(vlo), AddonMetaData.convert(vhi), range.charAt(range.length() - 1) == ']');
        }
        return new VersionRange(AddonMetaData.convert(range), true);
    }

    private static Version convert(String version) throws Exception {
        if (!version.isEmpty()) {
            String string = version.replaceAll("_", "-");
            try {
                return Version.parseVersion((String)string);
            }
            catch (Exception e) {
                Integer major = null;
                Integer minor = null;
                Integer micro = null;
                String qualifier = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                int nb = stringTokenizer.countTokens();
                String temp = stringTokenizer.nextToken();
                if (!AddonMetaData.isDigit(temp)) {
                    throw new NumberFormatException("Invalid major " + temp);
                }
                major = Integer.parseInt(temp);
                if (nb >= 1) {
                    temp = stringTokenizer.nextToken();
                    if (!AddonMetaData.isDigit(temp)) {
                        throw new NumberFormatException("Invalid minor " + temp);
                    }
                    minor = Integer.parseInt(temp);
                }
                StringBuilder qualifierBuilder = new StringBuilder();
                if (nb >= 2) {
                    temp = stringTokenizer.nextToken();
                    if (!AddonMetaData.isDigit(temp)) {
                        String replace = temp.replaceFirst("-", ".");
                        StringTokenizer tokenizer = new StringTokenizer(replace, ".");
                        if (!AddonMetaData.isDigit(temp = tokenizer.nextToken())) {
                            throw new NumberFormatException("Invalid micro " + temp);
                        }
                        micro = Integer.parseInt(temp);
                        qualifierBuilder.append(tokenizer.nextToken());
                    } else {
                        micro = Integer.parseInt(temp);
                    }
                }
                if (nb >= 3) {
                    boolean isInit;
                    int i = 3;
                    nb -= i;
                    boolean bl = isInit = !qualifierBuilder.toString().isEmpty();
                    while (nb > 0) {
                        if (isInit) {
                            qualifierBuilder.append("-");
                            qualifierBuilder.append(stringTokenizer.nextToken());
                        } else {
                            qualifierBuilder.append(stringTokenizer.nextToken());
                            if (nb > 1) {
                                qualifierBuilder.append("-");
                            }
                        }
                        ++i;
                        --nb;
                    }
                    qualifier = qualifierBuilder.toString();
                }
                StringBuilder versionBuilder = new StringBuilder();
                versionBuilder.append(major);
                if (minor != null) {
                    versionBuilder.append(".");
                    versionBuilder.append(minor);
                    if (micro != null) {
                        versionBuilder.append(".");
                        versionBuilder.append(micro);
                    }
                    if (qualifier != null && !qualifier.isEmpty()) {
                        versionBuilder.append(".");
                        versionBuilder.append(qualifier);
                    }
                }
                return Version.parseVersion((String)versionBuilder.toString());
            }
        }
        return null;
    }

    private static boolean isDigit(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

